/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableMetaData
implements ITableMetaData {
    private Map _columnsToIndexes;
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractTableMetaData.class);
    private DataTypeFactoryValidator dataTypeFactoryValidator = new DataTypeFactoryValidator();
    static /* synthetic */ Class class$org$dbunit$ext$db2$Db2DataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$DefaultDataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$h2$H2DataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$hsqldb$HsqldbDataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$mssql$MsSqlDataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$mysql$MySqlDataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$oracle$OracleDataTypeFactory;
    static /* synthetic */ Class class$org$dbunit$ext$oracle$Oracle10DataTypeFactory;

    protected static Column[] getPrimaryKeys(Column[] columns, String[] keyNames) {
        logger.debug("getPrimaryKeys(columns={}, keyNames={}) - start", (Object)columns, (Object)keyNames);
        return Columns.getColumns(keyNames, columns);
    }

    protected static Column[] getPrimaryKeys(String tableName, Column[] columns, IColumnFilter columnFilter) {
        if (logger.isDebugEnabled()) {
            logger.debug("getPrimaryKeys(tableName={}, columns={}, columnFilter={}) - start", new Object[]{tableName, columns, columnFilter});
        }
        return Columns.getColumns(tableName, columns, columnFilter);
    }

    public int getColumnIndex(String columnName) throws DataSetException {
        String columnNameUpperCase;
        Integer colIndex;
        logger.debug("getColumnIndex(columnName={}) - start", (Object)columnName);
        if (this._columnsToIndexes == null) {
            this._columnsToIndexes = this.createColumnIndexesMap(this.getColumns());
        }
        if ((colIndex = (Integer)this._columnsToIndexes.get(columnNameUpperCase = columnName.toUpperCase())) != null) {
            return colIndex;
        }
        throw new NoSuchColumnException(this.getTableName(), columnNameUpperCase, " (Non-uppercase input column: " + columnName + ") in ColumnNameToIndexes cache map. " + "Note that the map's column names are NOT case sensitive.");
    }

    private Map createColumnIndexesMap(Column[] columns) {
        HashMap<String, Integer> colsToIndexes = new HashMap<String, Integer>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            colsToIndexes.put(columns[i].getColumnName().toUpperCase(), new Integer(i));
        }
        return colsToIndexes;
    }

    public IDataTypeFactory getDataTypeFactory(IDatabaseConnection connection) throws SQLException {
        DatabaseConfig config;
        Object factoryObj;
        if (!IDataTypeFactory.class.isAssignableFrom((factoryObj = (config = connection.getConfig()).getProperty("http://www.dbunit.org/properties/datatypeFactory")).getClass())) {
            String msg = "Invalid datatype factory configured. Class '" + factoryObj.getClass() + "' does not implement '" + IDataTypeFactory.class + "'.";
            if (factoryObj instanceof String) {
                msg = msg + " Ensure not to specify the fully qualified class name as String but the concrete instance of the datatype factory (for example 'new OracleDataTypeFactory()').";
            }
            throw new DatabaseUnitRuntimeException(msg);
        }
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)factoryObj;
        Connection jdbcConnection = connection.getConnection();
        DatabaseMetaData metaData = jdbcConnection.getMetaData();
        String validationResult = this.dataTypeFactoryValidator.validate(metaData, dataTypeFactory);
        if (validationResult != null) {
            logger.warn("Potential problem found: " + validationResult);
        }
        return dataTypeFactory;
    }

    public static class DataTypeFactoryValidator {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$AbstractTableMetaData == null ? (class$org$dbunit$dataset$AbstractTableMetaData = AbstractTableMetaData.class$("org.dbunit.dataset.AbstractTableMetaData")) : class$org$dbunit$dataset$AbstractTableMetaData));
        private Map dataTypeFactoryToDbProductMap = new HashMap();

        public DataTypeFactoryValidator() {
            this.addValidCombinationInternal(class$org$dbunit$ext$db2$Db2DataTypeFactory == null ? (class$org$dbunit$ext$db2$Db2DataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.db2.Db2DataTypeFactory")) : class$org$dbunit$ext$db2$Db2DataTypeFactory, "db2");
            this.addValidCombinationInternal(class$org$dbunit$dataset$datatype$DefaultDataTypeFactory == null ? (class$org$dbunit$dataset$datatype$DefaultDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.dataset.datatype.DefaultDataTypeFactory")) : class$org$dbunit$dataset$datatype$DefaultDataTypeFactory, "derby");
            this.addValidCombinationInternal(class$org$dbunit$dataset$datatype$DefaultDataTypeFactory == null ? (class$org$dbunit$dataset$datatype$DefaultDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.dataset.datatype.DefaultDataTypeFactory")) : class$org$dbunit$dataset$datatype$DefaultDataTypeFactory, "PostgreSQL");
            this.addValidCombinationInternal(class$org$dbunit$ext$h2$H2DataTypeFactory == null ? (class$org$dbunit$ext$h2$H2DataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.h2.H2DataTypeFactory")) : class$org$dbunit$ext$h2$H2DataTypeFactory, "h2");
            this.addValidCombinationInternal(class$org$dbunit$ext$hsqldb$HsqldbDataTypeFactory == null ? (class$org$dbunit$ext$hsqldb$HsqldbDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.hsqldb.HsqldbDataTypeFactory")) : class$org$dbunit$ext$hsqldb$HsqldbDataTypeFactory, "hsql");
            this.addValidCombinationInternal(class$org$dbunit$ext$mssql$MsSqlDataTypeFactory == null ? (class$org$dbunit$ext$mssql$MsSqlDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.mssql.MsSqlDataTypeFactory")) : class$org$dbunit$ext$mssql$MsSqlDataTypeFactory, "mssql");
            this.addValidCombinationInternal(class$org$dbunit$ext$mssql$MsSqlDataTypeFactory == null ? (class$org$dbunit$ext$mssql$MsSqlDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.mssql.MsSqlDataTypeFactory")) : class$org$dbunit$ext$mssql$MsSqlDataTypeFactory, "Microsoft SQL Server");
            this.addValidCombinationInternal(class$org$dbunit$ext$mysql$MySqlDataTypeFactory == null ? (class$org$dbunit$ext$mysql$MySqlDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.mysql.MySqlDataTypeFactory")) : class$org$dbunit$ext$mysql$MySqlDataTypeFactory, "mysql");
            this.addValidCombinationInternal(class$org$dbunit$ext$oracle$OracleDataTypeFactory == null ? (class$org$dbunit$ext$oracle$OracleDataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.oracle.OracleDataTypeFactory")) : class$org$dbunit$ext$oracle$OracleDataTypeFactory, "oracle");
            this.addValidCombinationInternal(class$org$dbunit$ext$oracle$Oracle10DataTypeFactory == null ? (class$org$dbunit$ext$oracle$Oracle10DataTypeFactory = AbstractTableMetaData.class$("org.dbunit.ext.oracle.Oracle10DataTypeFactory")) : class$org$dbunit$ext$oracle$Oracle10DataTypeFactory, "oracle");
        }

        public void addValidCombination(Class iDataTypeFactoryImpl, String databaseProductName) {
            this.addValidCombinationInternal(iDataTypeFactoryImpl, databaseProductName);
        }

        private void addValidCombinationInternal(Class iDataTypeFactoryImpl, String databaseProductName) {
            logger.debug("addValidCombinationInternal(iDataTypeFactoryImpl={}, databaseProductName={}) - start", (Object)iDataTypeFactoryImpl, (Object)databaseProductName);
            this.addValidCombinationInternal(iDataTypeFactoryImpl, new String[]{databaseProductName});
        }

        private void addValidCombinationInternal(Class iDataTypeFactoryImpl, String[] databaseProductNameList) {
            logger.debug("addValidCombinationInternal(iDataTypeFactoryImpl={}, databaseProductNameList={}) - start", (Object)iDataTypeFactoryImpl, (Object)databaseProductNameList);
            HashSet<String> dbProductSet = (HashSet<String>)this.dataTypeFactoryToDbProductMap.get(iDataTypeFactoryImpl);
            if (dbProductSet == null) {
                dbProductSet = new HashSet<String>();
                this.dataTypeFactoryToDbProductMap.put(iDataTypeFactoryImpl, dbProductSet);
            }
            for (int i = 0; i < databaseProductNameList.length; ++i) {
                if (databaseProductNameList[i] == null || databaseProductNameList[i].trim().length() <= 0) continue;
                dbProductSet.add(databaseProductNameList[i].toLowerCase());
            }
        }

        public String validate(DatabaseMetaData databaseMetaData, IDataTypeFactory dataTypeFactory) throws SQLException {
            Class<?> dataTypeFactoryClass = dataTypeFactory.getClass();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            Collection validDbProductCollection = (Collection)this.dataTypeFactoryToDbProductMap.get(dataTypeFactoryClass);
            if (validDbProductCollection != null) {
                String lowerCaseDbProductName = databaseProductName.toLowerCase();
                Iterator iterator = validDbProductCollection.iterator();
                while (iterator.hasNext()) {
                    String validDbProduct = (String)iterator.next();
                    if (lowerCaseDbProductName.indexOf(validDbProduct) <= -1) continue;
                    logger.debug("The current database '" + databaseProductName + "' " + "fits to the configured data type factory '" + dataTypeFactory + "'. Validation successful.");
                    return null;
                }
            }
            String validationMessage = "The configured data type factory '" + dataTypeFactoryClass + "' might cause problems with the current database '" + databaseProductName + "' (e.g. some datatypes may not be supported properly). " + "In rare cases you might see this message because the list of supported database " + "products is incomplete (list=" + validDbProductCollection + "). " + "If so please request a java-class update via the forums.";
            return validationMessage;
        }
    }
}

