/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.sql.SQLException;
import java.util.Arrays;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DefaultFailureHandler;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.assertion.JUnitFailureFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitAssert {
    private static final Logger logger = LoggerFactory.getLogger((Class)DbUnitAssert.class);
    static /* synthetic */ Class class$org$dbunit$assertion$DbUnitAssert$ComparisonColumn;

    public void assertEqualsIgnoreCols(IDataSet expectedDataset, IDataSet actualDataset, String tableName, String[] ignoreCols) throws DatabaseUnitException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertEqualsIgnoreCols(expectedDataset={}, actualDataset={}, tableName={}, ignoreCols={}) - start", new Object[]{expectedDataset, actualDataset, tableName, Arrays.asList(ignoreCols)});
        }
        this.assertEqualsIgnoreCols(expectedDataset.getTable(tableName), actualDataset.getTable(tableName), ignoreCols);
    }

    public void assertEqualsIgnoreCols(ITable expectedTable, ITable actualTable, String[] ignoreCols) throws DatabaseUnitException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertEqualsIgnoreCols(expectedTable={}, actualTable={}, ignoreCols={}) - start", new Object[]{expectedTable, actualTable, Arrays.asList(ignoreCols)});
        }
        ITable expectedTableFiltered = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable actualTableFiltered = DefaultColumnFilter.excludedColumnsTable(actualTable, ignoreCols);
        this.assertEquals(expectedTableFiltered, actualTableFiltered);
    }

    public void assertEqualsByQuery(IDataSet expectedDataset, IDatabaseConnection connection, String sqlQuery, String tableName, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertEqualsByQuery(expectedDataset={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedDataset, connection, tableName, sqlQuery, ignoreCols});
        }
        ITable expectedTable = expectedDataset.getTable(tableName);
        this.assertEqualsByQuery(expectedTable, connection, tableName, sqlQuery, ignoreCols);
    }

    public void assertEqualsByQuery(ITable expectedTable, IDatabaseConnection connection, String tableName, String sqlQuery, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("assertEqualsByQuery(expectedTable={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedTable, connection, tableName, sqlQuery, ignoreCols});
        }
        ITable expected = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable queriedTable = connection.createQueryTable(tableName, sqlQuery);
        ITable actual = DefaultColumnFilter.excludedColumnsTable(queriedTable, ignoreCols);
        this.assertEquals(expected, actual);
    }

    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}) - start", (Object)expectedDataSet, (Object)actualDataSet);
        this.assertEquals(expectedDataSet, actualDataSet, null);
    }

    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet, FailureHandler failureHandler) throws DatabaseUnitException {
        int i;
        String[] actualNames;
        String[] expectedNames;
        if (logger.isDebugEnabled()) {
            logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}, failureHandler={}) - start", new Object[]{expectedDataSet, actualDataSet, failureHandler});
        }
        if (expectedDataSet == actualDataSet) {
            return;
        }
        if (failureHandler == null) {
            logger.debug("FailureHandler is null. Using default implementation");
            failureHandler = this.getDefaultFailureHandler();
        }
        if ((expectedNames = this.getSortedUpperTableNames(expectedDataSet)).length != (actualNames = this.getSortedUpperTableNames(actualDataSet)).length) {
            throw failureHandler.createFailure("table count", String.valueOf(expectedNames.length), String.valueOf(actualNames.length));
        }
        for (i = 0; i < expectedNames.length; ++i) {
            if (actualNames[i].equals(expectedNames[i])) continue;
            throw failureHandler.createFailure("tables", Arrays.asList(expectedNames).toString(), Arrays.asList(actualNames).toString());
        }
        for (i = 0; i < expectedNames.length; ++i) {
            String name = expectedNames[i];
            this.assertEquals(expectedDataSet.getTable(name), actualDataSet.getTable(name), failureHandler);
        }
    }

    public void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}) - start", (Object)expectedTable, (Object)actualTable);
        this.assertEquals(expectedTable, actualTable, (Column[])null);
    }

    public void assertEquals(ITable expectedTable, ITable actualTable, Column[] additionalColumnInfo) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}, additionalColumnInfo={}) - start", new Object[]{expectedTable, actualTable, additionalColumnInfo});
        FailureHandler failureHandler = null;
        if (additionalColumnInfo != null) {
            failureHandler = this.getDefaultFailureHandler(additionalColumnInfo);
        }
        this.assertEquals(expectedTable, actualTable, failureHandler);
    }

    public void assertEquals(ITable expectedTable, ITable actualTable, FailureHandler failureHandler) throws DatabaseUnitException {
        int actualRowsCount;
        logger.debug("assertEquals(expectedTable={}, actualTable={}, failureHandler={}) - start", new Object[]{expectedTable, actualTable, failureHandler});
        if (expectedTable == actualTable) {
            logger.debug("The given tables reference the same object. Will return immediately. (Table={})", (Object)expectedTable);
            return;
        }
        if (failureHandler == null) {
            logger.debug("FailureHandler is null. Using default implementation");
            failureHandler = this.getDefaultFailureHandler();
        }
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        int expectedRowsCount = expectedTable.getRowCount();
        if (expectedRowsCount != (actualRowsCount = actualTable.getRowCount())) {
            String msg = "row count (table=" + expectedTableName + ")";
            throw failureHandler.createFailure(msg, String.valueOf(expectedRowsCount), String.valueOf(actualRowsCount));
        }
        if (expectedRowsCount == 0 && actualRowsCount == 0) {
            logger.debug("Tables are empty, hence equals.");
            return;
        }
        Column[] expectedColumns = Columns.getSortedColumns(expectedMetaData);
        Column[] actualColumns = Columns.getSortedColumns(actualMetaData);
        Columns.ColumnDiff columnDiff = Columns.getColumnDiff(expectedMetaData, actualMetaData);
        if (columnDiff.hasDifference()) {
            String message = columnDiff.getMessage();
            throw failureHandler.createFailure(message, Columns.getColumnNamesAsString(expectedColumns), Columns.getColumnNamesAsString(actualColumns));
        }
        ComparisonColumn[] comparisonCols = this.getComparisonColumns(expectedTableName, expectedColumns, actualColumns, failureHandler);
        this.compareData(expectedTable, actualTable, comparisonCols, failureHandler);
    }

    protected FailureHandler getDefaultFailureHandler() {
        return this.getDefaultFailureHandler(null);
    }

    protected FailureHandler getDefaultFailureHandler(Column[] additionalColumnInfo) {
        DefaultFailureHandler failureHandler = new DefaultFailureHandler(additionalColumnInfo);
        failureHandler.setFailureFactory(new JUnitFailureFactory());
        return failureHandler;
    }

    protected void compareData(ITable expectedTable, ITable actualTable, ComparisonColumn[] comparisonCols, FailureHandler failureHandler) throws DataSetException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}, comparisonCols={}, failureHandler={}) - start", new Object[]{expectedTable, actualTable, comparisonCols, failureHandler});
        if (expectedTable == null) {
            throw new NullPointerException("The parameter 'expectedTable' must not be null");
        }
        if (actualTable == null) {
            throw new NullPointerException("The parameter 'actualTable' must not be null");
        }
        if (comparisonCols == null) {
            throw new NullPointerException("The parameter 'comparisonCols' must not be null");
        }
        if (failureHandler == null) {
            throw new NullPointerException("The parameter 'failureHandler' must not be null");
        }
        for (int i = 0; i < expectedTable.getRowCount(); ++i) {
            for (int j = 0; j < comparisonCols.length; ++j) {
                Object actualValue;
                ComparisonColumn compareColumn = comparisonCols[j];
                String columnName = compareColumn.getColumnName();
                DataType dataType = compareColumn.getDataType();
                Object expectedValue = expectedTable.getValue(i, columnName);
                if (this.skipCompare(columnName, expectedValue, actualValue = actualTable.getValue(i, columnName))) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("ignoring comparison " + expectedValue + "=" + actualValue + " on column " + columnName);
                    continue;
                }
                if (dataType.compare(expectedValue, actualValue) == 0) continue;
                Difference diff = new Difference(expectedTable, actualTable, i, columnName, expectedValue, actualValue);
                failureHandler.handle(diff);
            }
        }
    }

    protected boolean skipCompare(String columnName, Object expectedValue, Object actualValue) {
        return false;
    }

    protected ComparisonColumn[] getComparisonColumns(String expectedTableName, Column[] expectedColumns, Column[] actualColumns, FailureHandler failureHandler) {
        ComparisonColumn[] result = new ComparisonColumn[expectedColumns.length];
        for (int j = 0; j < expectedColumns.length; ++j) {
            Column expectedColumn = expectedColumns[j];
            Column actualColumn = actualColumns[j];
            result[j] = new ComparisonColumn(expectedTableName, expectedColumn, actualColumn, failureHandler);
        }
        return result;
    }

    protected String[] getSortedUpperTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getSortedUpperTableNames(dataSet={}) - start", (Object)dataSet);
        Object[] names = dataSet.getTableNames();
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((String)names[i]).toUpperCase();
        }
        Arrays.sort(names);
        return names;
    }

    public static class ComparisonColumn {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$assertion$DbUnitAssert$ComparisonColumn == null ? (class$org$dbunit$assertion$DbUnitAssert$ComparisonColumn = DbUnitAssert.class$("org.dbunit.assertion.DbUnitAssert$ComparisonColumn")) : class$org$dbunit$assertion$DbUnitAssert$ComparisonColumn));
        private String columnName;
        private DataType dataType;

        public ComparisonColumn(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            this.columnName = expectedColumn.getColumnName();
            this.dataType = this.getComparisonDataType(tableName, expectedColumn, actualColumn, failureHandler);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        private DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            if (logger.isDebugEnabled()) {
                logger.debug("getComparisonDataType(tableName={}, expectedColumn={}, actualColumn={}, failureHandler={}) - start", new Object[]{tableName, expectedColumn, actualColumn, failureHandler});
            }
            DataType expectedDataType = expectedColumn.getDataType();
            DataType actualDataType = actualColumn.getDataType();
            if (!expectedDataType.getClass().isInstance(actualDataType)) {
                if (expectedDataType instanceof UnknownDataType) {
                    return actualDataType;
                }
                if (actualDataType instanceof UnknownDataType) {
                    return expectedDataType;
                }
                String msg = "Incompatible data types: (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")";
                throw failureHandler.createFailure(msg, String.valueOf(expectedDataType), String.valueOf(actualDataType));
            }
            return expectedDataType;
        }
    }
}

