/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.utils;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class TimingMethodInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        Object thisObject = methodInvocation.getThis();
        Logger log = Logger.getLogger(thisObject.getClass());
        String method = methodInvocation.getMethod().getName();
        log.info((Object)(method + " begins"));
        long startTime = System.currentTimeMillis();
        boolean thrown = true;
        try {
            Object retVal = methodInvocation.proceed();
            thrown = false;
            object = retVal;
            log.info((Object)new StringBuilder(method).append(" ends").append(thrown ? " abnormally" : " normally").append(".  ~").append(System.currentTimeMillis() - startTime).append(" msecs."));
        }
        catch (Throwable throwable) {
            log.info((Object)new StringBuilder(method).append(" ends").append(thrown ? " abnormally" : " normally").append(".  ~").append(System.currentTimeMillis() - startTime).append(" msecs."));
            throw throwable;
        }
        return object;
    }
}

