/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.utils;

import java.util.Arrays;

public class EqualsUtils {
    public boolean equals(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lClass = lhs.getClass();
        Class<?> rClass = rhs.getClass();
        if (lClass.isArray() && rClass.isArray()) {
            Class<?> lCompType = lClass.getComponentType();
            Class<?> rCompType = rClass.getComponentType();
            if (lCompType.isPrimitive()) {
                if (rCompType.isPrimitive()) {
                    if (lCompType != rCompType) {
                        return false;
                    }
                    if (lCompType == Integer.TYPE) {
                        return Arrays.equals((int[])lhs, (int[])rhs);
                    }
                    if (lCompType == Boolean.TYPE) {
                        return Arrays.equals((boolean[])lhs, (boolean[])rhs);
                    }
                    if (lCompType == Byte.TYPE) {
                        return Arrays.equals((byte[])lhs, (byte[])rhs);
                    }
                    if (lCompType == Character.TYPE) {
                        return Arrays.equals((char[])lhs, (char[])rhs);
                    }
                    if (lCompType == Double.TYPE) {
                        return Arrays.equals((double[])lhs, (double[])rhs);
                    }
                    if (lCompType == Float.TYPE) {
                        return Arrays.equals((float[])lhs, (float[])rhs);
                    }
                    if (lCompType == Long.TYPE) {
                        return Arrays.equals((long[])lhs, (long[])rhs);
                    }
                    if (lCompType == Short.TYPE) {
                        return Arrays.equals((short[])lhs, (short[])rhs);
                    }
                }
                return false;
            }
            if (rCompType.isPrimitive()) {
                return false;
            }
            return Arrays.equals((Object[])lhs, (Object[])rhs);
        }
        return lhs.equals(rhs);
    }
}

