/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.beanlib.utils.External;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtils {
    public static <T extends Enum<T>, E> T fromExternal(Class<T> enumType, E externalized) {
        return (T)((Enum)EnumUtils.enumConstantDirectory(enumType).get(externalized));
    }

    public static <T extends Enum<T>> T fromString(Class<T> enumType, String s) {
        return (T)((Enum)EnumUtils.enumStringConstantDirectory(enumType).get(s));
    }

    public static <T extends Enum<T>> T fromOrdinal(Class<T> enumType, int ordinal) {
        return (T)((Enum)EnumUtils.enumOrdinalConstantDirectory(enumType).get(ordinal));
    }

    private static <T extends Enum<T>, E> Map<E, T> enumConstantDirectory(Class<T> enumType) {
        Map<Object, Enum> constantMap = (HashMap)LazyExternal.enumExternalDirectory.get(enumType);
        if (constantMap == null) {
            Enum[] constants = (Enum[])enumType.getEnumConstants();
            constantMap = new HashMap(2 * constants.length);
            for (Enum constant : constants) {
                constantMap.put(((External)((Object)constant)).externalize(), constant);
            }
            Map prev = LazyExternal.enumExternalDirectory.putIfAbsent(enumType, Collections.unmodifiableMap(constantMap));
            if (prev != null) {
                constantMap = prev;
            }
        }
        return constantMap;
    }

    private static <T extends Enum<T>> Map<String, T> enumStringConstantDirectory(Class<T> enumType) {
        Map<String, Enum> constantMap = (HashMap<String, Enum>)LazyToString.enumToStringDirectory.get(enumType);
        if (constantMap == null) {
            Enum[] constants = (Enum[])enumType.getEnumConstants();
            constantMap = new HashMap<String, Enum>(2 * constants.length);
            for (Enum constant : constants) {
                constantMap.put(constant.toString(), constant);
            }
            Map prev = LazyToString.enumToStringDirectory.putIfAbsent(enumType, Collections.unmodifiableMap(constantMap));
            if (prev != null) {
                constantMap = prev;
            }
        }
        return constantMap;
    }

    private static <T extends Enum<T>> Map<Integer, T> enumOrdinalConstantDirectory(Class<T> enumType) {
        Map<Integer, Enum> constantMap = (HashMap<Integer, Enum>)LazyOrdinal.enumOrdinalDirectory.get(enumType);
        if (constantMap == null) {
            Enum[] constants = (Enum[])enumType.getEnumConstants();
            constantMap = new HashMap<Integer, Enum>(2 * constants.length);
            for (Enum constant : constants) {
                constantMap.put(constant.ordinal(), constant);
            }
            Map prev = LazyOrdinal.enumOrdinalDirectory.putIfAbsent(enumType, Collections.unmodifiableMap(constantMap));
            if (prev != null) {
                constantMap = prev;
            }
        }
        return constantMap;
    }

    private EnumUtils() {
    }

    private static class LazyOrdinal {
        private static final ConcurrentMap<Class<?>, Map<?, ?>> enumOrdinalDirectory = new ConcurrentHashMap();

        private LazyOrdinal() {
        }
    }

    private static class LazyToString {
        private static final ConcurrentMap<Class<?>, Map<?, ?>> enumToStringDirectory = new ConcurrentHashMap();

        private LazyToString() {
        }
    }

    private static class LazyExternal {
        private static final ConcurrentMap<Class<?>, Map<?, ?>> enumExternalDirectory = new ConcurrentHashMap();

        private LazyExternal() {
        }
    }
}

