/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.utils;

import java.util.Currency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClassUtils {

    private static final int ENUM = 16384;

    public static String unqualify(Class<?> c) {
        if (c == null) {
            return null;
        }
        String fqcn = c.getName();
        int idx = fqcn.lastIndexOf(46);
        return idx == -1 ? fqcn : fqcn.substring(idx + 1);
    }

    public static boolean immutable(Class<?> c) {
        if (c == null) {
            return false;
        }
        return c == String.class || c.isPrimitive() || (c.getModifiers() & 0x4000) != 0 || Number.class.isAssignableFrom(c) && ClassUtils.isJavaPackage(c) || Boolean.class == c || Character.class == c || Byte.class == c || Currency.class == c;
    }

    public static boolean isJavaPackage(Class<?> c) {
        return c != null && ClassUtils.fqcn(c).startsWith("java.");
    }

    public static boolean isHibernatePackage(Class<?> c) {
        return c != null && ClassUtils.fqcn(c).startsWith("org.hibernate.");
    }

    public static String fqcn(Class<?> c) {
        if (c == null) {
            return null;
        }
        String cn = c.getName();
        if (c.isArray()) {
            int idx = cn.lastIndexOf("[");
            return idx + 2 < cn.length() ? cn.substring(idx + 2) : "";
        }
        return cn;
    }
}

