/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import net.sf.beanlib.BeanlibException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class BlobUtils {
    private Logger log = Logger.getLogger(this.getClass());

    public byte[] toByteArray(Blob fromBlob) {
        return this.toByteArray(fromBlob, 4000);
    }

    public byte[] toByteArray(Blob fromBlob, int bufferSize) {
        if (fromBlob == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] byArray = this.toByteArrayImpl(fromBlob, baos, bufferSize);
            return byArray;
        }
        catch (SQLException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (IOException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {
                    this.log.warn((Object)"", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArrayImpl(Blob fromBlob, ByteArrayOutputStream baos, int bufferSize) throws SQLException, IOException {
        byte[] buf = new byte[bufferSize];
        InputStream is = fromBlob.getBinaryStream();
        try {
            int dataSize;
            while ((dataSize = is.read(buf)) != -1) {
                baos.write(buf, 0, dataSize);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.log.warn((Object)"", (Throwable)ex);
                }
            }
        }
        return baos.toByteArray();
    }
}

