/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.util.LineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TextIterable
implements Iterable<String>,
Closeable {
    private final URL url;
    private final List<LineIterator> openedIterators = new ArrayList<LineIterator>();
    private volatile boolean returnNullUponEof;
    private String charsetname;
    private Charset charset;
    private CharsetDecoder charsetDecoder;

    public TextIterable(File file) throws MalformedURLException {
        this(file.toURI().toURL());
    }

    public TextIterable(URL url) {
        this.url = url;
    }

    public TextIterable(String resourcePath) {
        this(Thread.currentThread().getContextClassLoader().getResource(resourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineIterator iterator() {
        CharsetDecoder charsetDecoder;
        Charset charset;
        String charsetname;
        Iterable<String> iterable = this;
        synchronized (iterable) {
            charsetname = this.charsetname;
            charset = this.charset;
            charsetDecoder = this.charsetDecoder;
        }
        try {
            LineIterator ret = charsetDecoder != null ? new LineIterator(this, this.url.openStream(), this.returnNullUponEof, charsetDecoder) : (charset != null ? new LineIterator(this, this.url.openStream(), this.returnNullUponEof, charset) : (charsetname != null ? new LineIterator(this, this.url.openStream(), this.returnNullUponEof, Charset.forName(charsetname)) : new LineIterator(this, this.url.openStream(), this.returnNullUponEof, (Charset)null)));
            iterable = this.openedIterators;
            synchronized (iterable) {
                this.openedIterators.add(ret);
            }
            return ret;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LineIterator[] lineIterators;
        List<LineIterator> list = this.openedIterators;
        synchronized (list) {
            lineIterators = this.openedIterators.toArray(new LineIterator[this.openedIterators.size()]);
            Iterator<LineIterator> itr = this.openedIterators.iterator();
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
        }
        for (LineIterator li : lineIterators) {
            li.closeInPrivate();
        }
    }

    public int numberOfopenedIterators() {
        return this.openedIterators.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLineIterator(LineIterator li) {
        List<LineIterator> list = this.openedIterators;
        synchronized (list) {
            this.openedIterators.remove(li);
        }
    }

    public boolean isReturnNullUponEof() {
        return this.returnNullUponEof;
    }

    public void setReturnNullUponEof(boolean returnNullUponEof) {
        this.returnNullUponEof = returnNullUponEof;
    }

    public TextIterable withReturnNullUponEof(boolean returnNullUponEof) {
        this.setReturnNullUponEof(returnNullUponEof);
        return this;
    }

    public synchronized Charset getCharset() {
        return this.charset;
    }

    public synchronized void setCharset(Charset charset) {
        this.charset = charset;
        this.charsetname = null;
        this.charsetDecoder = null;
    }

    public TextIterable withCharset(Charset charset) {
        this.setCharset(charset);
        return this;
    }

    public synchronized CharsetDecoder getCharsetDecoder() {
        return this.charsetDecoder;
    }

    public synchronized void setCharsetDecoder(CharsetDecoder charsetDecoder) {
        this.charsetDecoder = charsetDecoder;
        this.charsetname = null;
        this.charset = null;
    }

    public TextIterable withCharsetDecoder(CharsetDecoder charsetDecoder) {
        this.setCharsetDecoder(charsetDecoder);
        return this;
    }

    public synchronized String getCharsetname() {
        return this.charsetname;
    }

    public synchronized void setCharsetname(String charsetname) {
        this.charsetname = charsetname;
        this.charset = null;
        this.charsetDecoder = null;
    }

    public TextIterable withCharsetname(String charsetname) {
        this.setCharsetname(charsetname);
        return this;
    }
}

