/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import net.sf.beanlib.util.TextIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
class LineIterator
implements Iterator<String>,
Closeable {
    private boolean hasNextExecuted;
    private String line;
    private LineNumberReader lnr;
    private final TextIterable textIterable;
    private final boolean returnNullUponEof;

    LineIterator(TextIterable textIterable, InputStream is, boolean returnNullUponEof, Charset charset) {
        this.textIterable = textIterable;
        this.returnNullUponEof = returnNullUponEof;
        InputStreamReader isr = null;
        try {
            isr = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
            this.lnr = new LineNumberReader(isr);
        }
        catch (Exception ex) {
            try {
                if (this.lnr != null) {
                    this.lnr.close();
                } else if (isr != null) {
                    isr.close();
                } else if (is != null) {
                    is.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
    }

    LineIterator(TextIterable textIterable, InputStream is, boolean returnNullUponEof, CharsetDecoder decoder) {
        this.textIterable = textIterable;
        this.returnNullUponEof = returnNullUponEof;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, decoder);
            this.lnr = new LineNumberReader(isr);
        }
        catch (Exception ex) {
            try {
                if (this.lnr != null) {
                    this.lnr.close();
                } else if (isr != null) {
                    isr.close();
                } else if (is != null) {
                    is.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextExecuted) {
            return this.line != null;
        }
        try {
            this.hasNextExecuted = true;
            if (this.lnr != null) {
                this.line = this.lnr.readLine();
                if (this.line == null) {
                    this.close();
                }
            }
            return this.line != null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String next() {
        if (this.hasNextExecuted) {
            this.hasNextExecuted = false;
            return this.line == null ? this.eof() : this.line;
        }
        return this.hasNext() ? this.next() : this.eof();
    }

    private String eof() {
        if (this.returnNullUponEof) {
            return null;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        if (this.lnr != null) {
            this.textIterable.removeLineIterator(this);
            this.closeInPrivate();
        }
    }

    public int getLineNumber() {
        return this.lnr == null ? -1 : this.lnr.getLineNumber();
    }

    void closeInPrivate() {
        if (this.lnr != null) {
            try {
                this.lnr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.line = null;
            this.lnr = null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close();
    }
}

