/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.spi;

import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;

public class TrivialCustomBeanTransformerFactories {
    public static CustomBeanTransformerSpi.Factory getNoopCustomTransformerFactory() {
        return NoopCustomTransformer.FACTORY;
    }

    public static CustomBeanTransformerSpi getNoopCustomTransformer() {
        return NoopCustomTransformer.SINGLETON;
    }

    public static CustomBeanTransformerSpi.Factory getIdentityCustomTransformerFactory() {
        return IdentityCustomTransformer.FACTORY;
    }

    public static CustomBeanTransformerSpi getIdentityCustomTransformer() {
        return IdentityCustomTransformer.SINGLETON;
    }

    public static CustomBeanTransformerSpi.Factory getNullCustomTransformerFactory() {
        return NullCustomTransformer.FACTORY;
    }

    public static CustomBeanTransformerSpi getNullCustomTransformer() {
        return NullCustomTransformer.SINGLETON;
    }

    private static class NullCustomTransformer {
        static final CustomBeanTransformerSpi.Factory FACTORY = new CustomBeanTransformerSpi.Factory(){

            public CustomBeanTransformerSpi newCustomBeanTransformer(BeanTransformerSpi contextBeanTransformer) {
                return SINGLETON;
            }
        };
        static final CustomBeanTransformerSpi SINGLETON = new CustomBeanTransformerSpi(){

            @Override
            public boolean isTransformable(Object from, Class<?> toClass, PropertyInfo propertyInfo) {
                return true;
            }

            @Override
            public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo) {
                return null;
            }
        };

        private NullCustomTransformer() {
        }
    }

    private static class IdentityCustomTransformer {
        static final CustomBeanTransformerSpi.Factory FACTORY = new CustomBeanTransformerSpi.Factory(){

            public CustomBeanTransformerSpi newCustomBeanTransformer(BeanTransformerSpi contextBeanTransformer) {
                return SINGLETON;
            }
        };
        static final CustomBeanTransformerSpi SINGLETON = new CustomBeanTransformerSpi(){

            @Override
            public boolean isTransformable(Object from, Class<?> toClass, PropertyInfo propertyInfo) {
                return true;
            }

            @Override
            public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo) {
                return (T)in;
            }
        };

        private IdentityCustomTransformer() {
        }
    }

    private static class NoopCustomTransformer {
        static final CustomBeanTransformerSpi.Factory FACTORY = new CustomBeanTransformerSpi.Factory(){

            public CustomBeanTransformerSpi newCustomBeanTransformer(BeanTransformerSpi contextBeanTransformer) {
                return SINGLETON;
            }
        };
        static final CustomBeanTransformerSpi SINGLETON = new CustomBeanTransformerSpi(){

            @Override
            public boolean isTransformable(Object from, Class<?> toClass, PropertyInfo propertyInfo) {
                return false;
            }

            @Override
            public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo) {
                return null;
            }
        };

        private NoopCustomTransformer() {
        }
    }
}

