/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.spi;

import java.util.ArrayList;
import java.util.List;
import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedCustomBeanTransformer
implements CustomBeanTransformerSpi {
    private final List<CustomBeanTransformerSpi> customTransformers = new ArrayList<CustomBeanTransformerSpi>();

    private ChainedCustomBeanTransformer() {
    }

    private ChainedCustomBeanTransformer appendCustomerBeanTransformer(CustomBeanTransformerSpi c) {
        this.customTransformers.add(c);
        return this;
    }

    @Override
    public boolean isTransformable(Object from, Class<?> toClass, PropertyInfo propertyInfo) {
        for (CustomBeanTransformerSpi cbt : this.customTransformers) {
            if (!cbt.isTransformable(from, toClass, propertyInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo) {
        boolean isTransformed = false;
        Object t = null;
        for (CustomBeanTransformerSpi cbt : this.customTransformers) {
            if (!cbt.isTransformable(in, toClass, propertyInfo)) continue;
            t = cbt.transform(isTransformed ? t : in, toClass, propertyInfo);
            isTransformed = true;
        }
        return (T)t;
    }

    public static class Factory
    implements CustomBeanTransformerSpi.Factory {
        private final List<CustomBeanTransformerSpi.Factory> customTransformerFactories = new ArrayList<CustomBeanTransformerSpi.Factory>();

        public Factory() {
        }

        public Factory(CustomBeanTransformerSpi.Factory ... customBeanTransformerFactories) {
            if (customBeanTransformerFactories != null) {
                for (CustomBeanTransformerSpi.Factory f : customBeanTransformerFactories) {
                    this.customTransformerFactories.add(f);
                }
            }
        }

        public Factory appendCustomerBeanTransformerFactory(CustomBeanTransformerSpi.Factory customBeanTransformerFactory) {
            this.customTransformerFactories.add(customBeanTransformerFactory);
            return this;
        }

        public CustomBeanTransformerSpi newCustomBeanTransformer(BeanTransformerSpi contextBeanTransformer) {
            ChainedCustomBeanTransformer chained = new ChainedCustomBeanTransformer();
            for (CustomBeanTransformerSpi.Factory f : this.customTransformerFactories) {
                chained.appendCustomerBeanTransformer(f.newCustomBeanTransformer(contextBeanTransformer));
            }
            return chained;
        }
    }
}

