/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Blob;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.provider.replicator.ImmutableReplicator;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.utils.ClassUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicatorTemplate {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final BeanTransformerSpi beanTransformer;

    protected ReplicatorTemplate(BeanTransformerSpi beanTransformer) {
        this.beanTransformer = beanTransformer;
    }

    protected ReplicatorTemplate() {
        this.beanTransformer = (BeanTransformerSpi)((Object)this);
    }

    protected final CustomBeanTransformerSpi getCustomerBeanTransformer() {
        return this.beanTransformer.getCustomBeanTransformer();
    }

    protected <T> T replicate(T from) {
        if (from == null) {
            return null;
        }
        try {
            Object ret = this.replicate(from, from.getClass());
            return (T)ret;
        }
        catch (SecurityException e) {
            throw new BeanlibException(e);
        }
    }

    protected <T> T replicate(Object from, Class<T> toClass) throws SecurityException {
        if (from == null) {
            return toClass.isPrimitive() ? (T)ImmutableReplicator.getDefaultPrimitiveValue(toClass) : null;
        }
        if (this.beanTransformer.getClonedMap().containsKey(from)) {
            Object to = this.beanTransformer.getClonedMap().get(from);
            return (T)to;
        }
        if (ClassUtils.immutable(from.getClass())) {
            return this.beanTransformer.getImmutableReplicatable().replicateImmutable(from, toClass);
        }
        if (from instanceof Collection) {
            return this.beanTransformer.getCollectionReplicatable().replicateCollection((Collection)from, toClass);
        }
        if (from.getClass().isArray()) {
            return this.beanTransformer.getArrayReplicatable().replicateArray(from, toClass);
        }
        if (from instanceof Map) {
            T ret = this.beanTransformer.getMapReplicatable().replicateMap((Map)from, toClass);
            return ret;
        }
        if (from instanceof Date) {
            return this.beanTransformer.getDateReplicatable().replicateDate((Date)from, toClass);
        }
        if (from instanceof Calendar) {
            return this.beanTransformer.getCalendarReplicatable().replicateCalendar((Calendar)from, toClass);
        }
        if (from instanceof Blob) {
            return this.beanTransformer.getBlobReplicatable().replicateBlob((Blob)from, toClass);
        }
        return this.replicateByBeanReplicatable(from, toClass);
    }

    protected <T> T replicateByBeanReplicatable(Object from, Class<T> toClass) {
        return this.beanTransformer.getBeanReplicatable().replicateBean(from, toClass);
    }

    protected final <T> T createToInstance(T from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return (T)this.createToInstance(from, from.getClass());
    }

    protected <T> T createToInstance(Object from, Class<T> toClass) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        Class<T> targetClass = this.chooseClass(from.getClass(), toClass);
        return this.newInstanceAsPrivileged(targetClass);
    }

    protected final <T> Class<T> chooseClass(Class<?> fromClass, Class<T> toClass) {
        if (!toClass.isAssignableFrom(fromClass) || Modifier.isAbstract(fromClass.getModifiers())) {
            return toClass;
        }
        Class<?> ret = fromClass;
        return ret;
    }

    protected <T> T transform(Object in, Class<T> toClass, PropertyInfo propertyInfo) {
        return this.beanTransformer.transform(in, toClass, propertyInfo);
    }

    protected void populateBean(Object fromMember, Object toMember) {
        this.beanTransformer.getBeanPopulatorSpiFactory().newBeanPopulator(fromMember, toMember).initBeanPopulatorBaseConfig(this.beanTransformer.getBeanPopulatorBaseConfig()).initTransformer(this.beanTransformer).populate();
    }

    protected <T> T createToInstanceWithComparator(T from, Comparator<?> comparator) throws SecurityException, NoSuchMethodException {
        return (T)this.createToInstanceWithComparator(from.getClass(), comparator);
    }

    private <T> T createToInstanceWithComparator(Class<T> toClass, Comparator<?> comparator) throws SecurityException, NoSuchMethodException {
        return this.newInstanceWithComparatorAsPrivileged(toClass, comparator);
    }

    protected final <T> T newInstanceAsPrivileged(Class<T> c) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        final Constructor<T> constructor = c.getDeclaredConstructor(new Class[0]);
        if (Modifier.isPublic(constructor.getModifiers())) {
            return c.newInstance();
        }
        return c.cast(AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new BeanlibException(e);
                }
                catch (InvocationTargetException e) {
                    throw new BeanlibException(e.getTargetException());
                }
                catch (InstantiationException e) {
                    throw new BeanlibException(e);
                }
            }
        }));
    }

    private <T> T newInstanceWithComparatorAsPrivileged(Class<T> c, final Comparator<?> comparator) throws SecurityException, NoSuchMethodException {
        final Constructor<T> constructor = c.getDeclaredConstructor(Comparator.class);
        if (Modifier.isPublic(constructor.getModifiers())) {
            try {
                return c.cast(constructor.newInstance(comparator));
            }
            catch (InstantiationException e) {
                throw new BeanlibException(e);
            }
            catch (IllegalAccessException e) {
                throw new BeanlibException(e);
            }
            catch (InvocationTargetException e) {
                throw new BeanlibException(e.getTargetException());
            }
        }
        return c.cast(AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(comparator);
                }
                catch (IllegalAccessException e) {
                    throw new BeanlibException(e);
                }
                catch (InvocationTargetException e) {
                    throw new BeanlibException(e.getTargetException());
                }
                catch (InstantiationException e) {
                    throw new BeanlibException(e);
                }
            }
        }));
    }

    protected final boolean containsTargetCloned(Object from) {
        return this.beanTransformer.getClonedMap().containsKey(from);
    }

    protected final Object getTargetCloned(Object from) {
        return this.beanTransformer.getClonedMap().get(from);
    }

    protected final Object putTargetCloned(Object from, Object to) {
        return this.beanTransformer.getClonedMap().put(from, to);
    }
}

