/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.ImmutableReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableReplicator
implements ImmutableReplicatorSpi {
    public static final Factory factory = new Factory();

    public static ImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newImmutableReplicatable(beanTransformer);
    }

    protected ImmutableReplicator() {
    }

    @Override
    public <V, T> T replicateImmutable(V immutableFrom, Class<T> toClass) {
        if (toClass.isPrimitive()) {
            if (ImmutableReplicator.sameType(toClass, immutableFrom.getClass())) {
                V ret = immutableFrom;
                return (T)ret;
            }
            return ImmutableReplicator.getDefaultPrimitiveValue(toClass);
        }
        Class<?> fromClass = immutableFrom.getClass();
        if (fromClass.isPrimitive()) {
            if (ImmutableReplicator.sameType(fromClass, toClass)) {
                V ret = immutableFrom;
                return (T)ret;
            }
            return ImmutableReplicator.getDefaultPrimitiveValue(toClass);
        }
        return toClass.isAssignableFrom(immutableFrom.getClass()) ? (T)toClass.cast(immutableFrom) : null;
    }

    public static <T> T getDefaultPrimitiveValue(Class<T> primitiveClass) {
        return (T)(primitiveClass == Boolean.TYPE ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)new Byte(0));
    }

    private static boolean sameType(Class<?> lhs, Class<?> rhs) {
        return lhs == Boolean.TYPE && rhs == Boolean.class || lhs == Byte.TYPE && rhs == Byte.class || lhs == Character.TYPE && rhs == Character.class || lhs == Short.TYPE && rhs == Short.class || lhs == Integer.TYPE && rhs == Integer.class || lhs == Long.TYPE && rhs == Long.class || lhs == Float.TYPE && rhs == Float.class || lhs == Double.TYPE && rhs == Double.class;
    }

    @ThreadSafe
    private static class Factory
    implements ImmutableReplicatorSpi.Factory {
        private Factory() {
        }

        public ImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
            return new ImmutableReplicator();
        }
    }
}

