/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.provider.replicator.ImmutableReplicator;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.ImmutableReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeteroImmutableReplicator
extends ImmutableReplicator {
    public static final Factory factory = new Factory();

    public static HeteroImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newImmutableReplicatable(beanTransformer);
    }

    protected HeteroImmutableReplicator() {
    }

    @Override
    public <V, T> T replicateImmutable(V immutableFrom, Class<T> toClass) {
        T result = super.replicateImmutable(immutableFrom, toClass);
        if (result != null) {
            return result;
        }
        if (toClass.isEnum() && immutableFrom instanceof Enum) {
            Enum enumFrom = (Enum)immutableFrom;
            try {
                Method values = toClass.getMethod("values", new Class[0]);
                return toClass.cast(Array.get(values.invoke(null, new Object[0]), enumFrom.ordinal()));
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return null;
    }

    @ThreadSafe
    private static class Factory
    implements ImmutableReplicatorSpi.Factory {
        private Factory() {
        }

        public HeteroImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
            return new HeteroImmutableReplicator();
        }
    }
}

