/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.provider.replicator.ReplicatorTemplate;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.DateReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateReplicator
extends ReplicatorTemplate
implements DateReplicatorSpi {
    private static final Factory factory = new Factory();

    public static DateReplicator newDateReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newDateReplicatable(beanTransformer);
    }

    protected DateReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    @Override
    public <T> T replicateDate(Date fromDate, Class<T> toClass) {
        if (!toClass.isAssignableFrom(fromDate.getClass())) {
            return null;
        }
        if (fromDate instanceof Timestamp) {
            Timestamp toDate = new Timestamp(fromDate.getTime());
            this.putTargetCloned(fromDate, toDate);
            return toClass.cast(toDate);
        }
        if (fromDate instanceof Time) {
            Time toDate = new Time(fromDate.getTime());
            this.putTargetCloned(fromDate, toDate);
            return toClass.cast(toDate);
        }
        if (fromDate instanceof java.sql.Date) {
            java.sql.Date toDate = new java.sql.Date(fromDate.getTime());
            this.putTargetCloned(fromDate, toDate);
            return toClass.cast(toDate);
        }
        Date toDate = new Date(fromDate.getTime());
        this.putTargetCloned(fromDate, toDate);
        return toClass.cast(toDate);
    }

    @ThreadSafe
    private static class Factory
    implements DateReplicatorSpi.Factory {
        private Factory() {
        }

        public DateReplicator newDateReplicatable(BeanTransformerSpi beanTransformer) {
            return new DateReplicator(beanTransformer);
        }
    }
}

