/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.provider.replicator.ReplicatorTemplate;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.replicator.CollectionReplicatorSpi;
import net.sf.beanlib.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionReplicator
extends ReplicatorTemplate
implements CollectionReplicatorSpi {
    private static final Factory factory = new Factory();
    static final Class<?> CLASS_ARRAY_ARRAYLIST;

    public static CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newCollectionReplicatable(beanTransformer);
    }

    protected CollectionReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    @Override
    public <V, T> T replicateCollection(Collection<V> fromCollection, Class<T> toClass) {
        Collection<V> toCollection;
        if (!toClass.isAssignableFrom(fromCollection.getClass())) {
            return null;
        }
        try {
            Collection<V> col;
            toCollection = col = this.createToCollection(fromCollection);
            this.putTargetCloned(fromCollection, toCollection);
            CustomBeanTransformerSpi customTransformer = this.getCustomerBeanTransformer();
            for (V fromMember : fromCollection) {
                Class<?> fromMemberClass;
                if (fromMember == null) {
                    toCollection.add(null);
                    continue;
                }
                if (super.containsTargetCloned(fromMember)) {
                    Object targetCloned = super.getTargetCloned(fromMember);
                    toCollection.add(targetCloned);
                    continue;
                }
                if (customTransformer != null && customTransformer.isTransformable(fromMember, fromMemberClass = fromMember.getClass(), null)) {
                    Object toMember = customTransformer.transform(fromMember, fromMemberClass, null);
                    super.putTargetCloned(fromMember, toMember);
                    toCollection.add(toMember);
                    continue;
                }
                V toMember = this.replicate(fromMember);
                toCollection.add(toMember);
            }
        }
        catch (SecurityException e) {
            throw new BeanlibException(e);
        }
        catch (InstantiationException e) {
            throw new BeanlibException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanlibException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanlibException(e.getTargetException());
        }
        return toClass.cast(toCollection);
    }

    protected <T> Collection<T> createToCollection(Collection<T> from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException {
        Class<?> fromClass = from.getClass();
        if (ClassUtils.isJavaPackage(fromClass)) {
            SortedSet fromSortedSet;
            Comparator<T> toComparator;
            if (from instanceof SortedSet && (toComparator = this.createToComparator(fromSortedSet = (SortedSet)from)) != null) {
                return this.createToSortedSetWithComparator(fromSortedSet, toComparator);
            }
            return this.createToInstanceAsCollection(from);
        }
        if (from instanceof SortedSet) {
            SortedSet fromSortedSet = (SortedSet)from;
            Comparator<T> toComparator = this.createToComparator(fromSortedSet);
            Constructor<?> constructor = fromClass.getConstructor(Comparator.class);
            Object[] initargs = new Object[]{toComparator};
            Collection ret = (Collection)constructor.newInstance(initargs);
            return ret;
        }
        if (from instanceof Set || from instanceof List) {
            Collection ret = (Collection)fromClass.newInstance();
            return ret;
        }
        this.log.warn((Object)("Don't know what collection object:" + fromClass + ", so assume List."));
        return new ArrayList(from.size());
    }

    protected final <T> Collection<T> createToInstanceAsCollection(Collection<T> from) throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (from.getClass() == CLASS_ARRAY_ARRAYLIST) {
            List list = (List)from;
            return new ArrayList(list.size());
        }
        Collection<T> ret = this.createToInstance(from);
        return ret;
    }

    protected final <T> SortedSet<T> createToSortedSetWithComparator(SortedSet<T> from, Comparator<?> comparator) throws NoSuchMethodException, SecurityException {
        return this.createToInstanceWithComparator(from, comparator);
    }

    protected <T> Comparator<T> createToComparator(SortedSet<T> fromSortedSet) {
        Comparator<T> fromComparator = fromSortedSet.comparator();
        if (fromComparator == null) {
            return null;
        }
        Comparator ret = this.replicateByBeanReplicatable(fromComparator, Comparator.class);
        return ret;
    }

    static {
        try {
            CLASS_ARRAY_ARRAYLIST = Class.forName("java.util.Arrays$ArrayList");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @ThreadSafe
    private static class Factory
    implements CollectionReplicatorSpi.Factory {
        private Factory() {
        }

        public CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
            return new CollectionReplicator(beanTransformer);
        }
    }
}

