/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.provider.BeanTransformer;
import net.sf.beanlib.provider.replicator.ReplicatorTemplate;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.replicator.BeanReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReplicator
extends ReplicatorTemplate
implements BeanReplicatorSpi {
    public BeanReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    public BeanReplicator(CustomBeanTransformerSpi.Factory ... customTransformerFactory) {
        super(new BeanTransformer(customTransformerFactory));
    }

    public BeanReplicator() {
        super(new BeanTransformer());
    }

    public <V> V replicateBean(V from) {
        return (V)this.replicateBean(from, from.getClass());
    }

    @Override
    public <V, T> T replicateBean(V from, Class<T> toClass) {
        return this.replicateBean(from, toClass, from);
    }

    protected <V, T> T replicateBean(V from, Class<T> toClass, V originalFrom) {
        T to;
        Class<?> fromClass = from.getClass();
        String fromClassName = fromClass.getName();
        if (fromClassName.startsWith("net.sf.cglib.")) {
            return null;
        }
        if (fromClassName.startsWith("java.") && !toClass.isAssignableFrom(fromClass)) {
            return null;
        }
        try {
            to = this.createToInstance(from, toClass);
        }
        catch (SecurityException e) {
            throw new BeanlibException(e);
        }
        catch (InstantiationException e) {
            throw new BeanlibException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanlibException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BeanlibException(e);
        }
        this.putTargetCloned(originalFrom, to);
        this.populateBean(from, to);
        return to;
    }
}

