/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.replicator;

import java.lang.reflect.Array;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.provider.replicator.ReplicatorTemplate;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.replicator.ArrayReplicatorSpi;
import net.sf.beanlib.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayReplicator
extends ReplicatorTemplate
implements ArrayReplicatorSpi {
    private static final Factory factory = new Factory();

    public static ArrayReplicator newArrayReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newArrayReplicatable(beanTransformer);
    }

    protected ArrayReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    @Override
    public <T> T replicateArray(Object arrayToCopy, Class<T> toClass) {
        if (!toClass.isAssignableFrom(arrayToCopy.getClass())) {
            return null;
        }
        Class<?> fromClass = arrayToCopy.getClass();
        Class<?> fromComponentType = fromClass.getComponentType();
        if (ClassUtils.immutable(fromComponentType)) {
            int len = Array.getLength(arrayToCopy);
            Object to = Array.newInstance(fromComponentType, len);
            System.arraycopy(arrayToCopy, 0, to, 0, len);
            this.putTargetCloned(arrayToCopy, to);
            return toClass.cast(to);
        }
        int len = Array.getLength(arrayToCopy);
        Object to = Array.newInstance(fromComponentType, len);
        this.putTargetCloned(arrayToCopy, to);
        Object[] fromArray = (Object[])arrayToCopy;
        Object[] toArray = (Object[])to;
        CustomBeanTransformerSpi customTransformer = this.getCustomerBeanTransformer();
        for (int i = fromArray.length - 1; i >= 0; --i) {
            Object toElement;
            Class<?> fromElementClass;
            Object fromElement = fromArray[i];
            if (fromElement == null) continue;
            if (super.containsTargetCloned(fromElement)) {
                toArray[i] = super.getTargetCloned(fromElement);
                continue;
            }
            if (customTransformer != null && customTransformer.isTransformable(fromElement, fromElementClass = fromElement.getClass(), null)) {
                Object toElement2 = customTransformer.transform(fromElement, fromElementClass, null);
                super.putTargetCloned(fromElement, toElement2);
                toArray[i] = toElement2;
                continue;
            }
            toArray[i] = toElement = this.replicate(fromElement);
        }
        return toClass.cast(toArray);
    }

    @ThreadSafe
    private static class Factory
    implements ArrayReplicatorSpi.Factory {
        private Factory() {
        }

        public ArrayReplicator newArrayReplicatable(BeanTransformerSpi beanTransformer) {
            return new ArrayReplicator(beanTransformer);
        }
    }
}

