/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.collector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.beanlib.provider.collector.PublicSetterMethodCollector;
import net.sf.beanlib.spi.BeanMethodCollector;

public class PublicSetterCollectionLastMethodCollector
implements BeanMethodCollector {
    private final BeanMethodCollector publicSetterMethodCollector = new PublicSetterMethodCollector();

    public Method[] collect(Object bean) {
        Method[] ma = this.publicSetterMethodCollector.collect(bean);
        ArrayList<Method> colMethods = new ArrayList<Method>();
        for (Method m : ma) {
            Class<?> paramType = m.getParameterTypes()[0];
            if (!Collection.class.isAssignableFrom(paramType) && !Map.class.isAssignableFrom(paramType)) continue;
            colMethods.add(m);
        }
        int colMethodsSize = colMethods.size();
        if (colMethodsSize == 0 || colMethodsSize == ma.length) {
            return ma;
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(ma));
        methods.removeAll(colMethods);
        methods.toArray(ma);
        int i = methods.size();
        for (Method m : colMethods) {
            ma[i++] = m;
        }
        return ma;
    }

    public String getMethodPrefix() {
        return this.publicSetterMethodCollector.getMethodPrefix();
    }
}

