/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider.collector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.beanlib.provider.collector.PublicSetterMethodCollector;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.utils.ClassUtils;

public class OrderedMethodCollector
implements BeanMethodCollector {
    private final BeanMethodCollector publicSetterMethodCollector = new PublicSetterMethodCollector();

    public Method[] collect(Object bean) {
        Method[] ma = this.publicSetterMethodCollector.collect(bean);
        ArrayList<Method> leaveMethods = new ArrayList<Method>();
        ArrayList<Method> colMethods = new ArrayList<Method>();
        for (Method m : ma) {
            Class<?> paramType = m.getParameterTypes()[0];
            if (ClassUtils.immutable(paramType) || Date.class.isAssignableFrom(paramType)) {
                leaveMethods.add(m);
                continue;
            }
            if (!Collection.class.isAssignableFrom(paramType) && !Map.class.isAssignableFrom(paramType)) continue;
            colMethods.add(m);
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(ma));
        if (leaveMethods.size() == ma.length || colMethods.size() == ma.length) {
            return ma;
        }
        methods.removeAll(leaveMethods);
        methods.removeAll(colMethods);
        leaveMethods.addAll(methods);
        leaveMethods.addAll(colMethods);
        return leaveMethods.toArray(ma);
    }

    public String getMethodPrefix() {
        return this.publicSetterMethodCollector.getMethodPrefix();
    }
}

