/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider;

import java.util.IdentityHashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.provider.BeanPopulator;
import net.sf.beanlib.provider.replicator.ArrayReplicator;
import net.sf.beanlib.provider.replicator.BeanReplicator;
import net.sf.beanlib.provider.replicator.CalendarReplicator;
import net.sf.beanlib.provider.replicator.CollectionReplicator;
import net.sf.beanlib.provider.replicator.DateReplicator;
import net.sf.beanlib.provider.replicator.ImmutableReplicator;
import net.sf.beanlib.provider.replicator.MapReplicator;
import net.sf.beanlib.provider.replicator.ReplicatorTemplate;
import net.sf.beanlib.provider.replicator.UnsupportedBlobReplicator;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.spi.BeanMethodFinder;
import net.sf.beanlib.spi.BeanPopulationExceptionHandler;
import net.sf.beanlib.spi.BeanPopulatorBaseConfig;
import net.sf.beanlib.spi.BeanPopulatorSpi;
import net.sf.beanlib.spi.BeanSourceHandler;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.ChainedCustomBeanTransformer;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.DetailedPropertyFilter;
import net.sf.beanlib.spi.PropertyFilter;
import net.sf.beanlib.spi.TrivialCustomBeanTransformerFactories;
import net.sf.beanlib.spi.replicator.ArrayReplicatorSpi;
import net.sf.beanlib.spi.replicator.BeanReplicatorSpi;
import net.sf.beanlib.spi.replicator.BlobReplicatorSpi;
import net.sf.beanlib.spi.replicator.CalendarReplicatorSpi;
import net.sf.beanlib.spi.replicator.CollectionReplicatorSpi;
import net.sf.beanlib.spi.replicator.DateReplicatorSpi;
import net.sf.beanlib.spi.replicator.ImmutableReplicatorSpi;
import net.sf.beanlib.spi.replicator.MapReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BeanTransformer
extends ReplicatorTemplate
implements BeanTransformerSpi {
    private final BeanPopulatorSpi.Factory beanPopulatorFactory;
    private Map<Object, Object> clonedMap = new IdentityHashMap<Object, Object>();
    private BeanPopulatorBaseConfig baseConfig = new BeanPopulatorBaseConfig();
    private CustomBeanTransformerSpi customTransformer = TrivialCustomBeanTransformerFactories.getNoopCustomTransformer();
    private ImmutableReplicatorSpi immutableReplicatable = ImmutableReplicator.newImmutableReplicatable(this);
    private CollectionReplicatorSpi collectionReplicatable = CollectionReplicator.newCollectionReplicatable(this);
    private MapReplicatorSpi mapReplicatable = MapReplicator.newMapReplicatable(this);
    private ArrayReplicatorSpi arrayReplicatable = ArrayReplicator.newArrayReplicatable(this);
    private BlobReplicatorSpi blobReplicatable = UnsupportedBlobReplicator.newBlobReplicatable(this);
    private DateReplicatorSpi dateReplicatable = DateReplicator.newDateReplicatable(this);
    private CalendarReplicatorSpi calendarReplicatable = CalendarReplicator.newCalendarReplicatable(this);
    private BeanReplicatorSpi beanReplicatable = new BeanReplicator(this);

    public BeanTransformer() {
        this(BeanPopulator.factory);
    }

    public BeanTransformer(CustomBeanTransformerSpi.Factory ... customBeanTransformerFactories) {
        this(BeanPopulator.factory);
        if (customBeanTransformerFactories != null && customBeanTransformerFactories.length > 0) {
            this.initCustomTransformerFactory(customBeanTransformerFactories.length == 1 ? customBeanTransformerFactories[0] : new ChainedCustomBeanTransformer.Factory(customBeanTransformerFactories));
        } else {
            this.initCustomTransformerFactory(null);
        }
    }

    protected BeanTransformer(BeanPopulatorSpi.Factory beanPopulatorFactory) {
        this.beanPopulatorFactory = beanPopulatorFactory;
    }

    @Override
    public BeanPopulatorSpi.Factory getBeanPopulatorSpiFactory() {
        return this.beanPopulatorFactory;
    }

    @Override
    public final void reset() {
        this.clonedMap = new IdentityHashMap<Object, Object>();
    }

    @Override
    public final <T> T transform(Object from, Class<T> toClass, PropertyInfo propertyInfo) {
        try {
            if (this.customTransformer.isTransformable(from, toClass, propertyInfo)) {
                return this.customTransformer.transform(from, toClass, propertyInfo);
            }
            return this.replicate(from, toClass);
        }
        catch (SecurityException e) {
            throw new BeanlibException(e);
        }
    }

    @Override
    public final BeanTransformer initCustomTransformerFactory(CustomBeanTransformerSpi.Factory customTransformer) {
        this.customTransformer = customTransformer.newCustomBeanTransformer(this);
        return this;
    }

    @Override
    public final BeanTransformer initPropertyFilter(PropertyFilter propertyFilter) {
        this.baseConfig.setPropertyFilter(propertyFilter);
        return this;
    }

    @Override
    public final BeanTransformer initBeanSourceHandler(BeanSourceHandler beanSourceHandler) {
        this.baseConfig.setBeanSourceHandler(beanSourceHandler);
        return this;
    }

    @Override
    public final BeanTransformer initDebug(boolean debug) {
        this.baseConfig.setDebug(debug);
        return this;
    }

    @Override
    public final BeanTransformer initDetailedPropertyFilter(DetailedPropertyFilter detailedPropertyFilter) {
        this.baseConfig.setDetailedPropertyFilter(detailedPropertyFilter);
        return this;
    }

    @Override
    public final BeanTransformer initReaderMethodFinder(BeanMethodFinder readerMethodFinder) {
        this.baseConfig.setReaderMethodFinder(readerMethodFinder);
        return this;
    }

    @Override
    public final BeanTransformer initSetterMethodCollector(BeanMethodCollector setterMethodCollector) {
        this.baseConfig.setSetterMethodCollector(setterMethodCollector);
        return this;
    }

    @Override
    public BeanTransformer initCollectionReplicatableFactory(CollectionReplicatorSpi.Factory factory) {
        this.collectionReplicatable = factory.newCollectionReplicatable(this);
        return this;
    }

    @Override
    public CollectionReplicatorSpi getCollectionReplicatable() {
        return this.collectionReplicatable;
    }

    @Override
    public BeanTransformer initMapReplicatableFactory(MapReplicatorSpi.Factory factory) {
        this.mapReplicatable = factory.newMapReplicatable(this);
        return this;
    }

    @Override
    public MapReplicatorSpi getMapReplicatable() {
        return this.mapReplicatable;
    }

    @Override
    public <K, V> Map<K, V> getClonedMap() {
        return this.clonedMap;
    }

    @Override
    public BeanTransformer initImmutableReplicatableFactory(ImmutableReplicatorSpi.Factory immutableReplicatableFactory) {
        this.immutableReplicatable = immutableReplicatableFactory.newImmutableReplicatable(this);
        return this;
    }

    @Override
    public ImmutableReplicatorSpi getImmutableReplicatable() {
        return this.immutableReplicatable;
    }

    @Override
    public BeanTransformer initArrayReplicatableFactory(ArrayReplicatorSpi.Factory arrayReplicatableFactory) {
        this.arrayReplicatable = arrayReplicatableFactory.newArrayReplicatable(this);
        return this;
    }

    @Override
    public ArrayReplicatorSpi getArrayReplicatable() {
        return this.arrayReplicatable;
    }

    @Override
    public BeanTransformer initBlobReplicatableFactory(BlobReplicatorSpi.Factory blobReplicatableFactory) {
        this.blobReplicatable = blobReplicatableFactory.newBlobReplicatable(this);
        return this;
    }

    @Override
    public BlobReplicatorSpi getBlobReplicatable() {
        return this.blobReplicatable;
    }

    @Override
    public BeanTransformer initBeanReplicatableFactory(BeanReplicatorSpi.Factory objectReplicatableFactory) {
        this.beanReplicatable = objectReplicatableFactory.newBeanReplicatable(this);
        return this;
    }

    @Override
    public BeanReplicatorSpi getBeanReplicatable() {
        return this.beanReplicatable;
    }

    @Override
    public BeanTransformerSpi initDateReplicatableFactory(DateReplicatorSpi.Factory dateReplicatableFactory) {
        this.dateReplicatable = dateReplicatableFactory.newDateReplicatable(this);
        return this;
    }

    @Override
    public BeanTransformerSpi initCalendarReplicatableFactory(CalendarReplicatorSpi.Factory calendarReplicatableFactory) {
        this.calendarReplicatable = calendarReplicatableFactory.newCalendarReplicatable(this);
        return this;
    }

    @Override
    public DateReplicatorSpi getDateReplicatable() {
        return this.dateReplicatable;
    }

    @Override
    public CalendarReplicatorSpi getCalendarReplicatable() {
        return this.calendarReplicatable;
    }

    @Override
    public BeanTransformer initBeanPopulationExceptionHandler(BeanPopulationExceptionHandler beanPopulationExceptionHandler) {
        this.baseConfig.setBeanPopulationExceptionHandler(beanPopulationExceptionHandler);
        return this;
    }

    @Override
    public BeanTransformerSpi initBeanPopulatorBaseConfig(BeanPopulatorBaseConfig baseConfig) {
        this.baseConfig = baseConfig;
        return this;
    }

    @Override
    public BeanPopulatorBaseConfig getBeanPopulatorBaseConfig() {
        return this.baseConfig;
    }

    @Override
    public PropertyFilter getPropertyFilter() {
        return this.baseConfig.getPropertyFilter();
    }

    @Override
    public BeanPopulationExceptionHandler getBeanPopulationExceptionHandler() {
        return this.baseConfig.getBeanPopulationExceptionHandler();
    }

    @Override
    public BeanSourceHandler getBeanSourceHandler() {
        return this.baseConfig.getBeanSourceHandler();
    }

    @Override
    public boolean isDebug() {
        return this.baseConfig.isDebug();
    }

    @Override
    public DetailedPropertyFilter getDetailedPropertyFilter() {
        return this.baseConfig.getDetailedPropertyFilter();
    }

    @Override
    public BeanMethodFinder getReaderMethodFinder() {
        return this.baseConfig.getReaderMethodFinder();
    }

    @Override
    public BeanMethodCollector getSetterMethodCollector() {
        return this.baseConfig.getSetterMethodCollector();
    }

    @Override
    public CustomBeanTransformerSpi getCustomBeanTransformer() {
        return this.customTransformer;
    }
}

