/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.PropertyInfo;
import net.sf.beanlib.provider.BeanTransformer;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.spi.BeanMethodFinder;
import net.sf.beanlib.spi.BeanPopulationExceptionHandler;
import net.sf.beanlib.spi.BeanPopulatorBaseConfig;
import net.sf.beanlib.spi.BeanPopulatorSpi;
import net.sf.beanlib.spi.BeanSourceHandler;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.DetailedPropertyFilter;
import net.sf.beanlib.spi.PropertyFilter;
import net.sf.beanlib.spi.Transformable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BeanPopulator
implements BeanPopulatorSpi {
    public static final Factory factory = new Factory();
    private final Logger log = Logger.getLogger(this.getClass());
    private final Object fromBean;
    private final Object toBean;
    private BeanPopulatorBaseConfig baseConfig = new BeanPopulatorBaseConfig();
    private Transformable transformer = new BeanTransformer(factory);

    public BeanPopulator(Object fromBean, Object toBean) {
        this.fromBean = fromBean;
        this.toBean = toBean;
    }

    private BeanTransformerSpi getBeanTransformerSpi() {
        return (BeanTransformerSpi)(this.transformer instanceof BeanTransformerSpi ? this.transformer : null);
    }

    private void processSetterMethod(Method setterMethod) {
        Method readerMethod;
        String methodName = setterMethod.getName();
        String propertyString = methodName.substring(this.baseConfig.getSetterMethodCollector().getMethodPrefix().length());
        if (this.baseConfig.isDebug() && this.log.isInfoEnabled()) {
            this.log.info((Object)("processSetterMethod: processing propertyString=" + propertyString + "" + ", fromClass=" + this.fromBean.getClass() + ", toClass=" + this.toBean.getClass()));
        }
        if ((readerMethod = this.baseConfig.getReaderMethodFinder().find(propertyString, this.fromBean)) == null) {
            return;
        }
        Class<?> paramType = setterMethod.getParameterTypes()[0];
        String propertyName = Introspector.decapitalize(propertyString);
        try {
            this.doit(setterMethod, readerMethod, paramType, propertyName);
        }
        catch (Exception ex) {
            this.baseConfig.getBeanPopulationExceptionHandler().initFromBean(this.fromBean).initToBean(this.toBean).initPropertyName(propertyName).initReaderMethod(readerMethod).initSetterMethod(setterMethod).handleException(ex, this.log);
        }
    }

    private <T> void doit(Method setterMethod, Method readerMethod, Class<T> paramType, String propertyName) {
        if (this.baseConfig.getDetailedPropertyFilter() != null && !this.baseConfig.getDetailedPropertyFilter().propagate(propertyName, this.fromBean, readerMethod, this.toBean, setterMethod)) {
            return;
        }
        if (this.baseConfig.getPropertyFilter() != null && !this.baseConfig.getPropertyFilter().propagate(propertyName, readerMethod)) {
            return;
        }
        Object propertyValue = this.invokeMethodAsPrivileged(this.fromBean, readerMethod, null);
        if (this.baseConfig.getBeanSourceHandler() != null) {
            this.baseConfig.getBeanSourceHandler().handleBeanSource(this.fromBean, readerMethod, propertyValue);
        }
        if (this.transformer != null) {
            PropertyInfo propertyInfo = new PropertyInfo(propertyName, this.fromBean, this.toBean);
            propertyValue = this.transformer.transform(propertyValue, paramType, propertyInfo);
        }
        if (this.baseConfig.isDebug() && this.log.isInfoEnabled()) {
            this.log.info((Object)("processSetterMethod: setting propertyName=" + propertyName));
        }
        Object[] args = new Object[]{propertyValue};
        this.invokeMethodAsPrivileged(this.toBean, setterMethod, args);
    }

    private Object invokeMethodAsPrivileged(final Object target, final Method method, final Object[] args) {
        if (Modifier.isPublic(method.getModifiers())) {
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException e) {
                throw new BeanlibException(e.getTargetException());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                try {
                    return method.invoke(target, args);
                }
                catch (IllegalArgumentException e) {
                    throw new BeanlibException(e);
                }
                catch (IllegalAccessException e) {
                    throw new BeanlibException(e);
                }
                catch (InvocationTargetException e) {
                    throw new BeanlibException(e.getTargetException());
                }
            }
        });
    }

    @Override
    public Transformable getTransformer() {
        return this.transformer;
    }

    @Override
    public BeanPopulator initTransformer(Transformable transformer) {
        this.transformer = transformer;
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initBeanPopulatorBaseConfig(this.baseConfig);
        }
        return this;
    }

    @Override
    public <T> T populate() {
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().getClonedMap().put(this.fromBean, this.toBean);
        }
        for (Method m : this.baseConfig.getSetterMethodCollector().collect(this.toBean)) {
            this.processSetterMethod(m);
        }
        Object ret = this.toBean;
        return (T)ret;
    }

    @Override
    public BeanPopulator initPropertyFilter(PropertyFilter propertyFilter) {
        this.baseConfig.setPropertyFilter(propertyFilter);
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initPropertyFilter(propertyFilter);
        }
        return this;
    }

    @Override
    public BeanPopulator initBeanSourceHandler(BeanSourceHandler beanSourceHandler) {
        this.baseConfig.setBeanSourceHandler(beanSourceHandler);
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initBeanSourceHandler(beanSourceHandler);
        }
        return this;
    }

    @Override
    public BeanPopulator initDebug(boolean debug) {
        this.baseConfig.setDebug(debug);
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initDebug(debug);
        }
        return this;
    }

    @Override
    public BeanPopulator initDetailedPropertyFilter(DetailedPropertyFilter detailedPropertyFilter) {
        this.baseConfig.setDetailedPropertyFilter(detailedPropertyFilter);
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initDetailedPropertyFilter(detailedPropertyFilter);
        }
        return this;
    }

    @Override
    public BeanPopulator initReaderMethodFinder(BeanMethodFinder readerMethodFinder) {
        if (readerMethodFinder != null) {
            this.baseConfig.setReaderMethodFinder(readerMethodFinder);
            if (this.getBeanTransformerSpi() != null) {
                this.getBeanTransformerSpi().initReaderMethodFinder(readerMethodFinder);
            }
        }
        return this;
    }

    @Override
    public BeanPopulator initSetterMethodCollector(BeanMethodCollector setterMethodCollector) {
        if (setterMethodCollector != null) {
            this.baseConfig.setSetterMethodCollector(setterMethodCollector);
            if (this.getBeanTransformerSpi() != null) {
                this.getBeanTransformerSpi().initSetterMethodCollector(setterMethodCollector);
            }
        }
        return this;
    }

    @Override
    public BeanPopulator initBeanPopulationExceptionHandler(BeanPopulationExceptionHandler beanPopulationExceptionHandler) {
        this.baseConfig.setBeanPopulationExceptionHandler(beanPopulationExceptionHandler);
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initBeanPopulationExceptionHandler(beanPopulationExceptionHandler);
        }
        return this;
    }

    @Override
    public BeanPopulator initBeanPopulatorBaseConfig(BeanPopulatorBaseConfig baseConfig) {
        this.baseConfig = baseConfig;
        if (this.getBeanTransformerSpi() != null) {
            this.getBeanTransformerSpi().initBeanPopulatorBaseConfig(baseConfig);
        }
        return this;
    }

    @Override
    public PropertyFilter getPropertyFilter() {
        return this.baseConfig.getPropertyFilter();
    }

    @Override
    public BeanPopulationExceptionHandler getBeanPopulationExceptionHandler() {
        return this.baseConfig.getBeanPopulationExceptionHandler();
    }

    @Override
    public BeanPopulatorBaseConfig getBeanPopulatorBaseConfig() {
        return this.baseConfig;
    }

    @Override
    public BeanSourceHandler getBeanSourceHandler() {
        return this.baseConfig.getBeanSourceHandler();
    }

    @Override
    public boolean isDebug() {
        return this.baseConfig.isDebug();
    }

    @Override
    public DetailedPropertyFilter getDetailedPropertyFilter() {
        return this.baseConfig.getDetailedPropertyFilter();
    }

    @Override
    public BeanMethodFinder getReaderMethodFinder() {
        return this.baseConfig.getReaderMethodFinder();
    }

    @Override
    public BeanMethodCollector getSetterMethodCollector() {
        return this.baseConfig.getSetterMethodCollector();
    }

    @ThreadSafe
    public static class Factory
    implements BeanPopulatorSpi.Factory {
        private Factory() {
        }

        public BeanPopulator newBeanPopulator(Object from, Object to) {
            return new BeanPopulator(from, to);
        }
    }
}

