/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class BeanDebugger {
    public void debugBeanProperties(Object bean, Logger log) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading bean properties for class " + bean.getClass()));
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] pda = bi.getPropertyDescriptors();
            for (int i = pda.length - 1; i > -1; --i) {
                PropertyDescriptor pd = pda[i];
                Method m = pd.getReadMethod();
                if (m == null || !log.isDebugEnabled()) continue;
                log.debug((Object)(pd.getName() + "={" + m.invoke(bean, new Object[0]) + "}"));
            }
        }
        catch (IntrospectionException e) {
            log.error((Object)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
    }
}

