/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.provider;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.sf.beanlib.BeanGetter;
import net.sf.beanlib.BeanlibException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanChecker {
    private final Logger log = Logger.getLogger(this.getClass());
    private final BeanGetter beanGetter = new BeanGetter();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean empty(Object fromBean, Class<?> k) {
        Class<?> fromClass = fromBean.getClass();
        Method[] ma = k.getDeclaredMethods();
        try {
            int i = 0;
            while (true) {
                block10: {
                    if (i >= ma.length) {
                        return true;
                    }
                    Method m = ma[i];
                    String name = m.getName();
                    try {
                        Method getter;
                        Object attrValue;
                        if (!name.startsWith("get") || !Modifier.isPublic(m.getModifiers()) || (attrValue = (getter = fromClass.getMethod(name, new Class[0])).invoke(fromBean, new Object[0])) == null) break block10;
                        if (attrValue instanceof String) {
                            String s = (String)attrValue;
                            if ((s = s.trim()).length() == 0) break block10;
                        }
                        return false;
                    }
                    catch (NoSuchMethodException ignore) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (SecurityException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)"", e.getTargetException());
            throw new BeanlibException(e.getTargetException());
        }
    }

    public boolean beanEquals(Object fBean, Object tBean) {
        if (fBean == tBean) {
            return true;
        }
        if (fBean == null || tBean == null) {
            return false;
        }
        try {
            BeanInfo bi_f = Introspector.getBeanInfo(fBean.getClass());
            PropertyDescriptor[] pda_f = bi_f.getPropertyDescriptors();
            Map<String, PropertyDescriptor> tMap = this.beanGetter.getPropertyName2DescriptorMap(tBean.getClass());
            if (pda_f.length != tMap.size()) {
                return false;
            }
            for (int i = pda_f.length - 1; i > -1; --i) {
                Object v_t;
                PropertyDescriptor pd_f = pda_f[i];
                PropertyDescriptor pd_t = tMap.get(pd_f.getName());
                Method m_f = pd_f.getReadMethod();
                Method m_t = pd_t.getReadMethod();
                if (m_f == null) {
                    if (m_t == null) continue;
                    return false;
                }
                if (m_t == null) {
                    return false;
                }
                Object v_f = m_f.invoke(fBean, new Object[0]);
                if (new EqualsBuilder().append(v_f, v_t = m_t.invoke(tBean, new Object[0])).isEquals()) continue;
                return false;
            }
            return true;
        }
        catch (IntrospectionException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)"", e.getTargetException());
            throw new BeanlibException(e.getTargetException());
        }
    }
}

