/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.jaxb2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.BeanlibException;
import net.sf.beanlib.provider.replicator.ImmutableReplicator;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.ImmutableReplicatorSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxb2ImmutableReplicator
extends ImmutableReplicator {
    public static final Factory factory = new Factory();

    public static Jaxb2ImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newImmutableReplicatable(beanTransformer);
    }

    protected Jaxb2ImmutableReplicator() {
    }

    @Override
    public <V, T> T replicateImmutable(V immutableFrom, Class<T> toClass) {
        T result = super.replicateImmutable(immutableFrom, toClass);
        if (result != null) {
            return result;
        }
        if (immutableFrom instanceof Enum) {
            return this.toValue(immutableFrom, toClass);
        }
        return null;
    }

    private <V, T> T toValue(V immutableFrom, Class<T> toClass) {
        try {
            Method valueMethod = immutableFrom.getClass().getMethod("value", new Class[0]);
            Object value = valueMethod.invoke(immutableFrom, new Object[0]);
            Method fromValueMethod = toClass.getMethod("fromValue", String.class);
            return toClass.cast(fromValueMethod.invoke(null, value));
        }
        catch (SecurityException e) {
            throw new BeanlibException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BeanlibException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanlibException(e.getTargetException());
        }
    }

    @ThreadSafe
    public static class Factory
    implements ImmutableReplicatorSpi.Factory {
        private Factory() {
        }

        public Jaxb2ImmutableReplicator newImmutableReplicatable(BeanTransformerSpi beanTransformer) {
            return new Jaxb2ImmutableReplicator();
        }
    }
}

