/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.io;

import java.io.IOException;
import java.io.Reader;

public class FastLineNumberReader
extends Reader {
    private static int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static int DEFAULT_LINE_LENGTH = 80;
    private Reader reader;
    private char[] charbuf;
    private int numCharInBuf;
    private int nextCharIdx;
    private boolean checkNextLF;
    private int lineNumber = -1;
    private EolEnum eolEnum = EolEnum.NONE;

    public FastLineNumberReader(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.reader = in;
        this.charbuf = new char[sz];
    }

    public FastLineNumberReader(Reader in) {
        this(in, DEFAULT_CHAR_BUFFER_SIZE);
    }

    private void fill() throws IOException {
        int n;
        while ((n = this.reader.read(this.charbuf, 0, this.charbuf.length)) == 0) {
        }
        this.numCharInBuf = n;
        this.nextCharIdx = 0;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int n1;
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1(cbuf, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.reader.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextCharIdx >= this.numCharInBuf) {
            if (len >= this.charbuf.length) {
                return this.reader.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextCharIdx >= this.numCharInBuf) {
            return -1;
        }
        int n = Math.min(len, this.numCharInBuf - this.nextCharIdx);
        System.arraycopy(this.charbuf, this.nextCharIdx, cbuf, off, n);
        this.nextCharIdx += n;
        return n;
    }

    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.charbuf = null;
    }

    public String readEndOfLine() throws IOException {
        if (this.checkNextLF) {
            this.checkNextLF = false;
            this.fill();
            if (this.nextCharIdx < this.numCharInBuf && this.charbuf[0] == '\n') {
                this.eolEnum = EolEnum.CR_LF;
                ++this.nextCharIdx;
            }
        }
        String ret = this.eolEnum.toString();
        this.eolEnum = EolEnum.NONE;
        return ret;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String readLine() throws IOException {
        if (this.checkNextLF) {
            this.readEndOfLine();
        }
        StringBuilder sb = null;
        while (true) {
            int i;
            if (this.nextCharIdx >= this.numCharInBuf) {
                this.fill();
            }
            if (this.nextCharIdx >= this.numCharInBuf) {
                if (sb != null && sb.length() > 0) {
                    ++this.lineNumber;
                    return sb.toString();
                }
                return null;
            }
            boolean eol = false;
            char c = '\u0000';
            for (i = this.nextCharIdx; i < this.numCharInBuf; ++i) {
                c = this.charbuf[i];
                if (c == '\n') {
                    this.eolEnum = EolEnum.LF;
                    eol = true;
                    break;
                }
                if (c != '\r') continue;
                this.eolEnum = EolEnum.CR;
                if (i + 1 < this.numCharInBuf) {
                    if (this.charbuf[i + 1] == '\n') {
                        this.eolEnum = EolEnum.CR_LF;
                    }
                } else {
                    this.checkNextLF = true;
                }
                eol = true;
                break;
            }
            int startChar = this.nextCharIdx;
            this.nextCharIdx = i;
            if (eol) {
                String str;
                if (sb == null) {
                    str = new String(this.charbuf, startChar, i - startChar);
                } else {
                    sb.append(this.charbuf, startChar, i - startChar);
                    str = sb.toString();
                }
                ++this.nextCharIdx;
                if (this.eolEnum == EolEnum.CR_LF) {
                    ++this.nextCharIdx;
                }
                ++this.lineNumber;
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder(DEFAULT_LINE_LENGTH);
            }
            sb.append(this.charbuf, startChar, i - startChar);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EolEnum {
        CR,
        LF,
        CR_LF,
        NONE;


        public String toString() {
            switch (this) {
                case CR: {
                    return "\r";
                }
                case LF: {
                    return "\n";
                }
                case CR_LF: {
                    return "\r\n";
                }
                case NONE: {
                    return "";
                }
            }
            throw new IllegalStateException("EolEnum " + (Object)((Object)this) + " is not yet supported.");
        }
    }
}

