/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.beanlib.BeanlibException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanGetter {
    private final Logger log = Logger.getLogger(this.getClass());

    public final String getPropertyAsString(Object bean, PropertyDescriptor pd) {
        Object ret;
        Method m = pd.getReadMethod();
        try {
            ret = m.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)"", e.getTargetException());
            throw new BeanlibException(e.getTargetException());
        }
        return ret == null ? (String)ret : ret.toString();
    }

    public final Map<String, PropertyDescriptor> getPropertyName2DescriptorMap(Class<?> beanClass) {
        BeanInfo bi;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        try {
            bi = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        PropertyDescriptor[] pda = bi.getPropertyDescriptors();
        for (int i = pda.length - 1; i > -1; --i) {
            PropertyDescriptor pd = pda[i];
            map.put(pd.getName(), pd);
        }
        return Collections.unmodifiableMap(map);
    }

    private int beanReaderHash(int hashCode, Method m, Object bean) throws IllegalAccessException, InvocationTargetException {
        int result = hashCode == 0 ? 17 : hashCode;
        Object v = m.invoke(bean, new Object[0]);
        if (v == null) {
            return result;
        }
        Class<?> c = m.getReturnType();
        return this.hashReturnValue(result, c, v);
    }

    private int hashReturnValue(int hashCode, Class<?> c, Object v) {
        if (v == null) {
            return hashCode;
        }
        if (c == Boolean.class) {
            boolean b = (Boolean)v;
            return b ? hashCode : this.addBeanHashCode(hashCode, 1);
        }
        if (c == Byte.class) {
            Byte b = (Byte)v;
            return this.addBeanHashCode(hashCode, b.byteValue());
        }
        if (c == Character.class) {
            Character ch = (Character)v;
            return this.addBeanHashCode(hashCode, ch.charValue());
        }
        if (c == Short.class) {
            Short s = (Short)v;
            return this.addBeanHashCode(hashCode, s.shortValue());
        }
        if (c == Integer.class) {
            Integer i = (Integer)v;
            return this.addBeanHashCode(hashCode, i);
        }
        if (c == Long.class) {
            Long L = (Long)v;
            long l = L;
            return this.addBeanHashCode(hashCode, (int)(l ^ l >>> 32));
        }
        if (c == Float.class) {
            Float F = (Float)v;
            return this.addBeanHashCode(hashCode, Float.floatToIntBits(F.floatValue()));
        }
        if (c == Array.class) {
            Object[] a = (Object[])v;
            for (int i = a.length - 1; i > -1; --i) {
                Object o = a[i];
                hashCode = this.addBeanHashCode(hashCode, this.hashReturnValue(hashCode, o.getClass(), o));
            }
            return hashCode;
        }
        return this.addBeanHashCode(hashCode, v.hashCode());
    }

    private int addBeanHashCode(int hashCode, int delta) {
        return 37 * hashCode + delta;
    }

    public int getBeanHashCode(Object bean) {
        BeanInfo bi;
        Class<?> beanClass = bean.getClass();
        try {
            bi = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        int hashCode = 0;
        PropertyDescriptor[] pda = bi.getPropertyDescriptors();
        try {
            for (int i = pda.length - 1; i > -1; --i) {
                PropertyDescriptor pd = pda[i];
                Method m = pd.getReadMethod();
                hashCode = this.beanReaderHash(hashCode, m, bean);
            }
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"", (Throwable)e);
            throw new BeanlibException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.log.error((Object)"", t);
            throw new BeanlibException(t);
        }
        return hashCode;
    }
}

