package alma.TMCDB.MonitorCollectorImpl;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POA;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.PortableServer.Servant;

import alma.ACS.CBDescIn;
import alma.ACS.CBDescInHelper;
import alma.ACS.CBDescInHolder;
import alma.ACS.CBDescOut;
import alma.ACS.CBdouble;
import alma.ACS.CBdoublePOA;
import alma.ACS.Callback;
import alma.ACS.CallbackOperations;
import alma.ACS.Monitor;
import alma.ACS.MonitorHelper;
import alma.ACS.OffShoot;
import alma.ACS.OffShootHelper;
import alma.ACS.OffShootOperations;
import alma.ACS.Plong;
import alma.ACS.PlongHelper;
import alma.ACS.PlongPOA;
import alma.ACS.PlongPOATie;
import alma.ACS.Property;
import alma.ACSErr.Completion;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.doubleBlobData;
import alma.acs.container.ContainerServices;

public abstract class MonitorPointHelper  extends MonitorPointBase implements CallbackOperations {
/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/*	protected String propertyName_m; /// property name

	protected long archivingInterval_m; // interval in which the value should be archived (and so monitored)

	private double valuePercentTrigger_m=0; // Delta value percentage a value can change before the value should be archived (and so monitored)

	protected MonitorBlob monitorBlob_m; ///here we put the values

	protected Monitor monitor_m = null; /// monitor of the property

	//Subscription_var subscription_m; /// Subscription for the alarm of the property

	OffShoot monitorCallback_m; ///callback CORBA reference
	//OffShoot alarmCallback_m; ///callback CORBA reference

	protected int curSeqPos_m = 0; ///current position to write in the sequence
	protected int curSeqInit_m = 0; ///current init of the circular buffer
	protected boolean bufferFull; ///status of buffer. If false data is sorted normally. If true buffer is full (data is stored but old data lost)

	protected int seqLen_m; ///sequence length

	protected boolean monitorSuppressed_m =false;
	//protected boolean alarmSuppressed_m=false ;
	//double alarmTimerTrigger_m;

	protected final int maxSeqSegments_m = 2; // maximum sequence segments. maxSeqSegments_m*prealocSeqLen_m defines the buffer maximum size
	protected final int prealocSeqLen_m = 100; // preallocated length of the sequence. This is the step that the sequence will grow

	Long backLogSize_m;
	Property  property_m;*/
	//TBLOB_SEQ[] blobDataSeq_m;
	//org.omg.CORBA.Any[] blobDataSeqTemp_m;
	/*private double valueTrigger_m=0; // Delta value describing how much a value can change before the value should be archived (and so monitored)
	
	Logger m_logger;*/
	protected OffShoot monitorServant_m;
	
	public MonitorPointHelper(Logger log, String propertyName, long archivingInterval, Property propertyRef, MonitorBlob mb) {
		
		this.propertyName_m=propertyName;
		this.archivingInterval_m=archivingInterval;
		this.property_m =propertyRef;
		monitorBlob_m=mb;
		monitorBlob_m.archiveOnChange = false;
		monitorBlob_m.propertyName = propertyName;
		monitorBlob_m.blobDataSeq = ORB.init().create_any();
		m_logger=log;
		valueTrigger_m =0;
		try
		{
			Any anyCharacteristic = ORB.init().create_any() ;
			String strCharacteristic;
			anyCharacteristic = property_m.get_characteristic_by_name("archive_suppress");
			strCharacteristic = anyCharacteristic.extract_string();
			m_logger.warning("----------------->Archive Suppress:"+strCharacteristic);
			if ( strCharacteristic.equals("true") || strCharacteristic.equals("1") ) {
				 m_logger.info("Values from property "+ propertyName_m+" will NOT be collected because archive_suppress is set to:"+strCharacteristic);
				 monitorSuppressed_m = true;
			}
			double archiveMaxInt;
			Any anyCharacteristic1 = ORB.init().create_any() ;
			String strCharacteristic1;
			anyCharacteristic1 = property_m.get_characteristic_by_name("archive_max_int");
			strCharacteristic1 = anyCharacteristic1.extract_string();
			archiveMaxInt= Double.parseDouble(strCharacteristic1)*(10000000.0); //we have to convert to 100s nsec.
			if (archiveMaxInt==0.0 )
			{
				m_logger.info("Values from property "+ propertyName_m+" will NOT be collected because by time interval, because archive_max_int is 0");
				//archivingInterval_m = 0;
			}	
		} catch(SystemException ex) {
			m_logger.info("CORBA problem in MonitorPoint:"+ ex.getMessage());
		} catch(Exception e) {
			m_logger.info("Problems in MonitorPoint:"+ e.getMessage());
		}
	}

	@Override
	public boolean negotiate(long time_to_transmit, CBDescOut desc) {
		return true;
	}

	@Override
	public void activate(ContainerServices containerServices_m) {
	}

	@Override
	public void deactivate(ContainerServices containerServices_m) {
		
	}
 
	@Override
	public void startMonitoring(ContainerServices containerServices_m) {
		CBDescIn cbDescIn =new CBDescIn(0,0,0);
		try {
			if (monitor_m!=null) {
				return;
			}
			Request req =null;
			req=property_m._request("create_monitor");
			org.omg.CORBA.Any cb =req.add_named_in_arg("CB");
			cb.insert_Object(monitorServant_m._duplicate(),OffShootHelper.type());
			org.omg.CORBA.Any cb1 =req.add_named_in_arg("CBDescIn");
			CBDescInHelper.insert(cb1, cbDescIn);
			req.set_return_type (MonitorHelper.type());
			req.invoke();
			if (req.result() != null)
			{
			
				org.omg.CORBA.Any id =req.return_value();
				Object m=MonitorHelper.extract(id);
				monitor_m = MonitorHelper.narrow(m);
				if(monitorSuppressed_m == true)
					monitor_m.suspend();

				monitor_m.set_timer_trigger(archivingInterval_m);
				//monitor_m->set_value_trigger(valueTrigger_m);
				req = monitor_m._request("set_value_trigger");
				org.omg.CORBA.Any vt =req.add_named_in_arg ("delta");
				vt.insert_double(valueTrigger_m);
				if(valueTrigger_m == 0) {
					org.omg.CORBA.Any vt1=req.add_named_in_arg ("enable");
					vt1.insert_boolean(false);
				}
				else {
					org.omg.CORBA.Any vt2=req.add_named_in_arg ("enable");
					vt2.insert_boolean(true);
				}
				org.omg.CORBA.TypeCode result_tc = ORB.init().get_primitive_tc(TCKind.tk_void);
				req.set_return_type(result_tc);
				req.invoke();
				//monitor_m->set_value_percent_trigger(valuePercentTrigger_m);
				req = monitor_m._request("set_value_percent_trigger");
				org.omg.CORBA.Any vt3 =req.add_named_in_arg ("delta");
				vt3.insert_double(valueTrigger_m);
				if(valuePercentTrigger_m == 0) {
					org.omg.CORBA.Any vt4=req.add_named_in_arg ("enable");
					vt4.insert_boolean(false);
				}
				else {
					org.omg.CORBA.Any vt5=req.add_named_in_arg ("enable");
					vt5.insert_boolean(true);
				}
				req.set_return_type(result_tc);
				req.invoke();
			}else {
				m_logger.severe("Jacorb problem!");
			}
		}catch (SystemException e) {
			m_logger.severe("Jacorb problem! "+e.getMessage());
		}
	}

	@Override
	public void stopMonitoring() {
		try
		{
			if ( monitor_m!=null )
			    monitor_m.destroy();
				monitor_m = null;
			}
		catch(SystemException ex)
		{
			ex.printStackTrace();
		}
		
	}

	@Override
	public void enable_archiving() {
		monitorSuppressed_m = false;
		if ( monitor_m==null )
			return; // The monitor does not exist.
		monitor_m.resume();
		
	}

	@Override
	public void suppress_archiving() {
		monitorSuppressed_m = true;
		if ( monitor_m==null )
			return; // The monitor does not exist.
		monitor_m.suspend();
		
	}

	@Override
	public void set_archiving_interval(long time) {
		if (monitor_m != null) {
//			monitor.set_timer_trigger(archivingInterval);
			monitor_m.set_timer_trigger(10000000);
		}
	}

	@Override
	public void setPropertySerialNumber(String[] serialNumbers) {
		monitorBlob_m.propertySerialNumber = serialNumbers;
		
	}

	public void fillSeq() {
			
	}

	@Override
	public String getPropertyName() {
		return propertyName_m;
	}

}
