package alma.TMCDB.MonitorCollectorImpl;

import java.util.logging.Logger;

import org.omg.PortableServer.Servant;

import alma.ACS.Monitor;
import alma.ACS.OffShoot;
import alma.ACS.Property;
import alma.TMCDB.MonitorBlob;
import alma.acs.container.ContainerServices;

public abstract class MonitorPointBase {
	
	protected String propertyName_m; /// property name

	protected long archivingInterval_m; // interval in which the value should be archived (and so monitored)

	protected double valuePercentTrigger_m=0; // Delta value percentage a value can change before the value should be archived (and so monitored)

	protected MonitorBlob monitorBlob_m =null; ///here we put the values
	
	protected Property property_m;

	protected Monitor monitor_m = null; /// monitor of the property

	//Subscription_var subscription_m; /// Subscription for the alarm of the property

	OffShoot monitorCallback_m; ///callback CORBA reference
	//OffShoot alarmCallback_m; ///callback CORBA reference

	protected int curSeqPos_m = 0; ///current position to write in the sequence
	protected int curSeqInit_m = 0; ///current init of the circular buffer
	protected boolean bufferFull=false; ///status of buffer. If false data is sorted normally. If true buffer is full (data is stored but old data lost)

	protected int seqLen_m; ///sequence length

	protected boolean monitorSuppressed_m =false;
	//protected boolean alarmSuppressed_m=false ;
	//double alarmTimerTrigger_m;

	protected final int maxSeqSegments_m = 2; // maximum sequence segments. maxSeqSegments_m*prealocSeqLen_m defines the buffer maximum size
	protected final int prealocSeqLen_m = 100; // preallocated length of the sequence. This is the step that the sequence will grow

	protected Long backLogSize_m =32L;
	
	
	//org.omg.CORBA.Any[] blobDataSeqTemp_m;
	protected double valueTrigger_m=0.; // Delta value describing how much a value can change before the value should be archived (and so monitored)
	protected Logger m_logger;
	
	protected Object mutex =new Object();
	
	
	abstract void activate(ContainerServices containerServices_m);

	abstract void deactivate(ContainerServices containerServices_m);

	abstract void startMonitoring(ContainerServices containerServices_m);
	
	abstract void stopMonitoring();

	abstract void enable_archiving();

	abstract void suppress_archiving();

	abstract void set_archiving_interval(long time);

	abstract void setPropertySerialNumber(String[] serialNumbers);

	abstract String getPropertyName();
}
