/**
 *
 */
package alma.TMCDB.MonitorCollectorImpl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jacorb.orb.Any;
import org.jacorb.orb.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.TypeCode;
import org.omg.PortableServer.Servant;

import alma.ACS.CBDescOut;
import alma.ACS.CBdouble;
import alma.ACS.CBdoubleHelper;
import alma.ACS.CBdoubleOperations;
import alma.ACS.Monitor;
import alma.ACS.OffShootOperations;
import alma.ACS.Property;
import alma.ACS.ROdouble;
import alma.ACS.ROdoubleHelper;
import alma.ACS.Subscription;
import alma.ACS.CBdoublePOA;
import alma.ACS.CallbackOperations;
import alma.ACS.CBBoolPOA;
import alma.ACS.CBDescIn;
import alma.ACSErr.Completion;
import alma.ACSErr.CompletionHolder;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.doubleBlobData;
import alma.TMCDB.doubleBlobDataHolder;
import alma.TMCDB.doubleBlobDataSeqHelper;
import alma.acs.container.ContainerServices;
import alma.acs.time.TimeHelper;


/**
 * @author Claudio Tanci
 *
 */
public class MonitorPoint<T extends Servant & OffShootOperations, TBLOB_SEQ extends org.omg.CORBA.portable.IDLEntity> implements Monitorable {

	private Monitor monitor;			// monitor of the property
	private Boolean monitorSuppressed;
	private Subscription subscription;	// Subscription for the alarm of the property

	private String name;				// property name
	private Property ref;				// property reference
	private String type;					// property type
	private short valueType;
	private long archivingInterval;		// interval in which the value should be archived (and so monitored)
	private MonitorBlob monitorBlob;

	private TBLOB_SEQ blobDataSeq1; 
	private doubleBlobData[] blobDataSeq = new doubleBlobData[100];
	private int curSeqPos = 0;
	// TODO review
	private OffShootOperations monitorCallback; // in C++ there is a ACS::OffShoot_var monitorCallback_m and a ACS::OffShoot_var alarmCallback_m
	private T monitorServant_m;
	private Logger m_logger;

	public MonitorPoint(String propertyName, Property propertyRef,
			String propertyType, short propertyValueType, long archivingInterval, MonitorBlob monitorBlob) {

		this.name = propertyName;
		this.ref = propertyRef;
		this.type = propertyType;
		this.valueType = propertyValueType;
		this.archivingInterval = archivingInterval;
		this.monitorBlob = monitorBlob;

		// TODO
		this.monitorBlob.archiveOnChange = false;

		this.monitorBlob.typeOfValue = propertyValueType;
		this.monitorBlob.propertyName = name;
		this.monitorBlob.blobDataSeq = ORB.init().create_any();

		System.out.println("---> new MonitorPoint("+propertyName+", REF, "+propertyType+", "+archivingInterval+", "+monitorBlob);

		monitorBlob.propertyName = name;
//		monitorBlob_m.typeOfValue =

	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#activate(alma.acs.container.ContainerServices)
	 */
	@Override
	public void activate(ContainerServices cs) {
		try {
			monitorCallback = cs.activateOffShoot(monitorServant_m);
//			alarmServant_m ->_remove_ref(); //Decrease ref count to 1
		} catch (AcsJContainerServicesEx e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#deactivate(alma.acs.container.ContainerServices)
	 */
	@Override
	public void deactivate(ContainerServices cs) {
		try {
			cs.deactivateOffShoot(monitorServant_m);
		} catch (AcsJContainerServicesEx e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#startMonitoring()
	 */
	@Override
	public void startMonitoring(ContainerServices cs) {

		System.out.println("--->MonitorPoint.startMonitoring()");
		if (monitor == null) {

//			Request r = ref._request("create_monitor");
//			r.add_in_arg().insert_string("CB");
//			monitorCallback.

			double retValue = 0.0;

			System.out.println("----> "+name+" "+type);
			if (type.equals("ROdouble")) {
				//CBdoublePOA m_cb = new CBdoublePOA()
				CBdoublePOA m_cb = new CBdoublePOA() {
					@Override
					public boolean negotiate(long time_to_transmit, CBDescOut desc) {
						System.out.println("---> Negotiating");
						return true;
					}

					@Override
					public void working(double value, Completion c, CBDescOut desc) {
//						TimeHelper th = new TimeHelper();
//						System.out.println(th.getUTCDate()+"-"+name+":value: "+value);

						System.out.println("---> Working: "+name+" +curseqpos="+curSeqPos+" value="+value+" timestamp="+c.timeStamp+" blobdataseqL="+blobDataSeq.length);
//						System.out.println("---> Working: "+name+" +curseqpos="+curSeqPos+" value="+value+" timestamp="+c.timeStamp);

//						System.out.println("---> curseqpos PREupdated: "+curSeqPos);

						if (curSeqPos<100) {

							try {
								doubleBlobData a = new doubleBlobData();
								a.value = value;
								a.time = c.timeStamp;
								blobDataSeq[curSeqPos] = a;

								curSeqPos++;
//								System.out.println("---> curseqpos updated: "+curSeqPos);
							} catch (Exception e) {
								System.out.println("---> ECCEZIONE!!!"+e.toString());
							}

						}
					}

					@Override
					public void done(double value, Completion c, CBDescOut desc) {
						System.out.println("---> Done: "+name+" value="+value);
					}
				};

				CBdouble cbdouble;
				try {
					cbdouble = CBdoubleHelper.narrow(cs.activateOffShoot(m_cb, CBdoubleOperations.class));

					CBDescIn cbDescIn = new CBDescIn();
					CompletionHolder completionHolder = new CompletionHolder();

					ROdouble n = ROdoubleHelper.narrow(ref);
					retValue = n.get_sync(completionHolder);

					monitor = n.create_monitor(cbdouble, cbDescIn);

					System.out.println("---> MonitorPoint.startMonitoring "+name+" archiving interval: "+archivingInterval);
					monitor.set_timer_trigger(archivingInterval);
//					m_monitor.set_value_trigger(0.5, true);


				} catch (AcsJContainerServicesEx e) {
					System.out.println("---> !!! Eccezione !!!");
				}
			}
			//add here float and etc
		}
	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#stopMonitoring()
	 */
	@Override
	public void stopMonitoring() {

		if (monitor != null) {
			monitor.destroy();
		}

	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#enable_archiving()
	 */
	@Override
	public void enable_archiving() {

		monitorSuppressed = false;

		/*
		 * Java uses the null value to indicate that a reference does not
		 * reference an object, this is equivalent to CORBA::is_nil() in C++
		 */
		if (monitor != null) {
			monitor.resume();
		}
	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#suppress_archiving()
	 */
	@Override
	public void suppress_archiving() {

		monitorSuppressed = true;

		if (monitor != null) {
			monitor.suspend();
		}

	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#set_archiving_interval(long)
	 */
	@Override
	public void set_archiving_interval(long time) {

		archivingInterval = time;
		if (monitor != null) {
//			monitor.set_timer_trigger(archivingInterval);
			monitor.set_timer_trigger(10000000);
		}
	}

	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#setPropertySerialNumber(java.lang.String[])
	 */
	@Override
	public void setPropertySerialNumber(String[] serialNumbers) {
		monitorBlob.propertySerialNumber = serialNumbers;
	}


	/* (non-Javadoc)
	 * @see alma.TMCDB.MonitorCollectorImpl.MonitorPoint#fillSeq()
	 */
	@Override
	public void fillSeq() {

		// we adjust the length
//		blobDataSeq. length (curSeqPos);

		System.out.println("---> fillSeq Start");
		

		doubleBlobData[] tmpBlobDataSeq = new doubleBlobData[curSeqPos];
		for (int i = 0; i < curSeqPos; i++) {

			System.out.println("---> BlobDataSeq "+blobDataSeq[i].time+" "+blobDataSeq[i].value);
			tmpBlobDataSeq[i] = blobDataSeq[i];
		}

//		monitorBlob.blobDataSeq = ORB.init().create_any();
		doubleBlobDataSeqHelper.insert(monitorBlob.blobDataSeq, tmpBlobDataSeq);
		//set a length of a sequence back
		curSeqPos = 0;

		System.out.println("---> fillSeq Stop, any type="+monitorBlob.blobDataSeq.type()+" (doubleBlobDataSeqHelper.type()=)"+doubleBlobDataSeqHelper.type());
	}

	@Override
	public String getPropertyName() {
		return name;
	}

	@Override
	public void setLogger(Logger log) {
		m_logger=log;
		
	}



}
