/**
 *
 */
package alma.TMCDB.MonitorCollectorImpl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

import alma.ACS.CharacteristicComponent;
import alma.ACS.CharacteristicComponentHelper;
import alma.ACSErr.ErrorTrace;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.MonitorArchiver.Controller;
import alma.MonitorArchiver.ControllerHelper;
import alma.MonitorErr.CollectorRegistrationFailedEx;
import alma.MonitorErr.DeviceAlreadyRegisteredEx;
import alma.MonitorErr.DeviceNotRegisteredEx;
import alma.MonitorErr.RegisteringDeviceProblemEx;
import alma.MonitorErr.StartMonitoringProblemEx;
import alma.MonitorErr.StopMonitoringProblemEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.MonitorCollectorOperations;
import alma.TMCDB.MonitorDataBlock;
import alma.TMCDB.doubleBlobData;
import alma.TMCDB.doubleBlobDataSeqHelper;
import alma.TMCDB.propertySerailNumber;
import alma.TMCDB.MonitorCollectorImpl.MonitorComponent;
import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;

/**
 * @author Claudio Tanci, ported from ACS C++ MonitorCollectorImpl by bjeram
 *
 */
public class MonitorCollectorImpl extends ComponentImplBase implements
		MonitorCollectorOperations {

	/*
	 * Monitor Control instance name, a note from MonitorCollectorImpl.cpp
	 * suggests that the instance could be obtained by type instead
	 * ("IDL:alma/MonitorArchiver/Controller:1.0")
	 */
	private String monitorControllerInstanceName = "ARCHIVE/TMCDB/MONITOR_CONTROL";
	private Controller monitorControl;
	private boolean isRegistered=false;

	/*
	 *  Monitored components maps, thread safe.
	 *  component instances names as keys.
	 */
	ConcurrentHashMap<String, MonitorComponent> monitorComponents = new ConcurrentHashMap<String, MonitorComponent>();
	ConcurrentHashMap<String, Boolean> isComponentMonitored = new ConcurrentHashMap<String, Boolean>();
	/**
	 *
	 */
	public MonitorCollectorImpl() {

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.acs.component.ComponentImplBase#initialize(alma.acs.container.
	 * ContainerServices)
	 */
	@Override
	public void initialize(ContainerServices containerServices)
			throws ComponentLifecycleException {

		super.initialize(containerServices);

		/*
		 * Registering with the controller, which will assign a blobber to this
		 * collector (m_containerServices is a ContainerServices from
		 * ComponentImplBase)
		 */
		org.omg.CORBA.Object monitorControllerRef;
		try {
			monitorControllerRef = m_containerServices
					.getComponentNonSticky(monitorControllerInstanceName);
			monitorControl = ControllerHelper
					.narrow(monitorControllerRef);
			monitorControl.registerCollector(name());
			if (!isRegistered)
				isRegistered=true;
		} catch (AcsJContainerServicesEx e) {
			// TODO: is this correct?
			throw new ComponentLifecycleException(e);
		} catch (CollectorRegistrationFailedEx e) {
			// TODO: deal with this exception, e.g. raise an alarm.
			m_logger.info("---> Failed registration");

		}

		m_logger.info("---> Java MonitorCollector v. 0.2");

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.acs.component.ComponentImplBase#cleanUp()
	 */
	@Override
	public void cleanUp() throws AcsJComponentCleanUpEx {

		// For the moment ComponentImplBase.cleanUp() does nothing
		super.cleanUp();
		if (isRegistered) {
				monitorControl.deregisterCollector(name());
			if (!monitorComponents.isEmpty()) {
				monitorComponents.clear();
			}
		}

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#registerMonitoredDevice(java.lang
	 * .String, java.lang.String)
	 */
	@Override
	public void registerMonitoredDevice(String componentName,
			String serialNumber) throws RegisteringDeviceProblemEx,
			DeviceAlreadyRegisteredEx {

		m_logger.info("---> registerMonitoredDevice");
		registerCollocatedMonitoredDevice(componentName, serialNumber);

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#registerCollocatedMonitoredDevice
	 * (java.lang.String, java.lang.String)
	 */
	
	public void registerCollocatedMonitoredDevice (String componentName,
			String serialNumber) throws RegisteringDeviceProblemEx,
			DeviceAlreadyRegisteredEx {

		m_logger.info("---> registerCollocatedMonitoredDevice");
		registerMonitoredComponentWithSerial(componentName, serialNumber, true);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#registerNonCollocatedMonitoredDevice
	 * (java.lang.String, java.lang.String)
	 */
	@Override
	public void registerNonCollocatedMonitoredDevice(String componentName,
			String serialNumber) throws RegisteringDeviceProblemEx,
			DeviceAlreadyRegisteredEx {

		registerMonitoredComponentWithSerial(componentName, serialNumber, false);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.TMCDB.MonitorCollectorOperations#
	 * registerMonitoredDeviceWithMultipleSerial(java.lang.String,
	 * alma.TMCDB.propertySerailNumber[])
	 */
	public void registerMonitoredDeviceWithMultipleSerial(String componentName,
			propertySerailNumber[] serialNumbers)
			throws RegisteringDeviceProblemEx, DeviceAlreadyRegisteredEx {

		registerMonitoredComponentWithMultipleSerial(componentName,
				serialNumbers, true);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.TMCDB.MonitorCollectorOperations#
	 * registerCollocatedMonitoredDeviceWithMultipleSerial(java.lang.String,
	 * alma.TMCDB.propertySerailNumber[])
	 */
	public void registerCollocatedMonitoredDeviceWithMultipleSerial(
			String componentName, propertySerailNumber[] serialNumbers)
			throws RegisteringDeviceProblemEx, DeviceAlreadyRegisteredEx {

		registerMonitoredComponentWithMultipleSerial(componentName,
				serialNumbers, false);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.TMCDB.MonitorCollectorOperations#
	 * registerNonCollocatedMonitoredDeviceWithMultipleSerial(java.lang.String,
	 * alma.TMCDB.propertySerailNumber[])
	 */
	public void registerNonCollocatedMonitoredDeviceWithMultipleSerial(
			String componentName, propertySerailNumber[] serialNumbers)
			throws RegisteringDeviceProblemEx, DeviceAlreadyRegisteredEx {

		registerMonitoredComponentWithMultipleSerial(componentName,
				serialNumbers, false);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#deregisterMonitoredDevice(java.
	 * lang.String)
	 */
	@Override
	public void deregisterMonitoredDevice(String componentName)
			throws DeviceNotRegisteredEx {

		m_logger.info("---> deregisterMonitoredDevice "+componentName);
		for (String k : monitorComponents.keySet()) {
			m_logger.info("---> deregisterMonitoredDevice monitored component key "+k);
		}
		//System.out.flush();

		if (monitorComponents.containsKey(componentName)) {

			// stop the monitoring
			if (isComponentMonitored.get(componentName)){
				MonitorComponent mc = monitorComponents.get(componentName);
				mc.stopMonitoring();
			}

			m_logger.info("---> deregisterMonitoredDevice - stopped monitoring "+componentName);
			//System.out.flush();

			for (String k : monitorComponents.keySet()) {
				m_logger.info("---> monitored component key "+k);
				//System.out.flush();
			}

			// remove the component from monitorComponents
			monitorComponents.remove(componentName);

		} else {
			// TODO: what is the standard way in ACS Java components to raise an
			// exception?
			// here I have copied the C++ way
			ErrorTrace errorTrace = new ErrorTrace();
			errorTrace.file = new Throwable().getStackTrace()[1].getFileName();
			errorTrace.lineNum = new Throwable().getStackTrace()[1]
					.getLineNumber();
			throw new DeviceNotRegisteredEx(errorTrace);
		}
	}

	/**
	 * @param componentName
	 * @param serialNumber
	 * @param b
	 * @throws RegisteringDeviceProblemEx
	 * @throws DeviceAlreadyRegisteredEx
	 */
	private void registerMonitoredComponentWithSerial(String componentName,
			String serialNumber, boolean checkCollocation)
			throws DeviceAlreadyRegisteredEx, RegisteringDeviceProblemEx {

		m_logger.info("---> registerMonitoredComponentWithSerial");

		try {
			MonitorComponent mc = registerMonitoredComponent(componentName,
					checkCollocation);
			mc.setDeviceSerialNumber(serialNumber);
		} catch (AcsJContainerServicesEx e) {
			/*
			 * In the C++ implementation there is a check to remove mc from
			 * monitorComponents. I don't think it is possibile here to receive
			 * an AcsJContainerServicesEx and a mc in monitorComponents.
			 */
			throw new RegisteringDeviceProblemEx(e.getErrorTrace());
		}
	}

	/**
	 * @param componentName
	 * @param serialNumber
	 * @param b
	 * @throws DeviceAlreadyRegisteredEx
	 * @throws RegisteringDeviceProblemEx
	 */
	private void registerMonitoredComponentWithMultipleSerial(
			String componentName, propertySerailNumber[] serialNumbers,
			boolean checkCollocation) throws DeviceAlreadyRegisteredEx, RegisteringDeviceProblemEx {

		try {
			MonitorComponent mc = registerMonitoredComponent(componentName,
					checkCollocation);

			for (propertySerailNumber propertySerailNumber : serialNumbers) {
				mc.setPropertySerialNumber(propertySerailNumber.propertyName, propertySerailNumber.serialNumbers);
			}

		} catch (AcsJContainerServicesEx e) {
			/*
			 * In the C++ implementation there is a check to remove mc from
			 * monitorComponents. I don't think it is possibile here to receive
			 * an AcsJContainerServicesEx and a mc in monitorComponents.
			 */
			throw new RegisteringDeviceProblemEx(e.getErrorTrace());
		}
	}

	/**
	 * @param componentName
	 * @param checkCollocation
	 * @return
	 * @throws DeviceAlreadyRegisteredEx
	 * @throws AcsJContainerServicesEx
	 */
	private MonitorComponent registerMonitoredComponent(
			String componentName, boolean checkCollocation)
			throws DeviceAlreadyRegisteredEx, AcsJContainerServicesEx {

		/*
		 * In the C++ implementation an ACE_GUARD_RETURN and an
		 * ACE_Hash_Map_Manager are used.
		 * I will use a ConcurrentHashMap
		 * TODO: check if this is correct
		 */

		// Check to see if the component is already registered
		if (monitorComponents.containsKey(componentName)) {
			// TODO: what is the standard way in ACS Java components to raise an
			// exception?
			// here I have copied the C++ way
			ErrorTrace errorTrace = new ErrorTrace();
			errorTrace.file = new Throwable().getStackTrace()[1].getFileName();
			errorTrace.lineNum = new Throwable().getStackTrace()[1]
					.getLineNumber();
			throw new DeviceAlreadyRegisteredEx(errorTrace);

		}

		org.omg.CORBA.Object componentRef = m_containerServices
				.getComponentNonSticky(componentName);
		CharacteristicComponent component = CharacteristicComponentHelper
				.narrow(componentRef);
		
		// TODO check if colocation is requested
		// if (checkCollocation && (!component. )) {
		// // TODO: what is the standard way in ACS Java components to raise
		// an exception?
		// // here I have copied the C++ way
		// ErrorTrace errorTrace = new ErrorTrace();
		// errorTrace.file = new
		// Throwable().getStackTrace()[1].getFileName();
		// errorTrace.lineNum = new
		// Throwable().getStackTrace()[1].getLineNumber();
		// throw new NotCollocatedComponentEx(errorTrace);
		// }

		MonitorComponent mc = new MonitorComponent(component,
				m_containerServices);
		mc.addAllProperties();

		monitorComponents.put(componentName, mc);
		isComponentMonitored.put(componentName,false);

		return mc;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#startMonitoring(java.lang.String)
	 */
	@Override
	public void startMonitoring(String componentName)
			throws StartMonitoringProblemEx {

		if (monitorComponents.containsKey(componentName)) {
			// try {
			MonitorComponent mc = monitorComponents.get(componentName);
			mc.startMonitoring();
			// }
			isComponentMonitored.replace(componentName, true);

		} else {
			// TODO: what is the standard way in ACS Java components to raise an
			// exception?
			// here I have copied the C++ way
			ErrorTrace errorTrace = new ErrorTrace();
			errorTrace.file = new Throwable().getStackTrace()[1].getFileName();
			errorTrace.lineNum = new Throwable().getStackTrace()[1]
					.getLineNumber();
			throw new StartMonitoringProblemEx(errorTrace);
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#stopMonitoring(java.lang.String)
	 */
	@Override
	public void stopMonitoring(String componentName)
			throws StopMonitoringProblemEx {

		m_logger.info("---> stopMonitoring");
		for (String k : monitorComponents.keySet()) {
			m_logger.info("---> monitored component key "+k);
		}

		if (monitorComponents.containsKey(componentName)) {
			// try {
			if (isComponentMonitored.get(componentName)){
				MonitorComponent mc = (MonitorComponent) monitorComponents
						.get(componentName);
				mc.stopMonitoring();
				isComponentMonitored.replace(componentName,false);
			}
			
			// }

		} else {
			// TODO: what is the standard way in ACS Java components to raise an
			// exception?
			// here I have copied the C++ way
			ErrorTrace errorTrace = new ErrorTrace();
			errorTrace.file = new Throwable().getStackTrace()[1].getFileName();
			errorTrace.lineNum = new Throwable().getStackTrace()[1]
					.getLineNumber();
			throw new StopMonitoringProblemEx(errorTrace);
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see alma.TMCDB.MonitorCollectorOperations#getMonitorData()
	 */
	@Override
	public MonitorDataBlock[] getMonitorData() {



		MonitorDataBlock[] monitorDataBlock = new MonitorDataBlock[monitorComponents
				.size()];

		int i = 0;
		for (MonitorComponent mc : monitorComponents.values()) {

			mc.fillSeq();
			monitorDataBlock[i] = mc.getMonitorDataBlock();
			i++;
		}

//		System.out.println("---> MonitorCollector getMonitorData, length="+monitorDataBlock[0].monitorBlobs.length);
//		for (MonitorBlob b : monitorDataBlock[0].monitorBlobs) {
//			System.out.println("---> "+b.propertyName);
//		}

		return monitorDataBlock;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#set_archiving_interval(java.lang
	 * .String, java.lang.String, long)
	 */
	@Override
	public void set_archiving_interval(String componentName,
			String propertyName, long time) {

		if (monitorComponents.containsKey(componentName)) {
			// try {
			MonitorComponent mc = (MonitorComponent) monitorComponents
					.get(componentName);
			mc.set_archiving_interval(propertyName, time);
			// }

		} else {
			// TODO: What to do here? C++ implementation throw a
			// DeviceNotRegisteredEx, against IDL specification
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#suppress_archiving(java.lang.String
	 * , java.lang.String)
	 */
	@Override
	public void suppress_archiving(String componentName, String propertyName) {

		if (monitorComponents.containsKey(componentName)) {
			// try {
			MonitorComponent mc = (MonitorComponent) monitorComponents
					.get(componentName);
			mc.suppress_archiving(propertyName);
			// }

		} else {
			// TODO: What to do here? C++ implementation throw a
			// DeviceNotRegisteredEx, against IDL specification
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see
	 * alma.TMCDB.MonitorCollectorOperations#enable_archiving(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public void enable_archiving(String componentName, String propertyName) {

		if (monitorComponents.containsKey(componentName)) {
			// try {
			MonitorComponent mc = (MonitorComponent) monitorComponents
					.get(componentName);
			mc.enable_archiving(propertyName);
			// }

		} else {
			// TODO: What to do here? C++ implementation throw a
			// DeviceNotRegisteredEx, it seems not compliant with IDL specification. (?)
		}
	}

	
	
}
