package alma.TMCDB.MonitorCollectorImpl;

import java.util.logging.Logger;

import org.omg.CORBA.SystemException;
import alma.ACS.CBDescOut;
import alma.ACS.CBlongLongOperations;
import alma.ACS.CBlongLongPOA;
import alma.ACS.CBlongLongPOATie;
import alma.ACS.Property;
import alma.ACS.ROlongLong;
import alma.ACS.ROlongLongHelper;
import alma.ACSErr.Completion;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.longBlobData;
import alma.TMCDB.longLongBlobData;
import alma.TMCDB.longLongBlobDataSeqHelper;
import alma.acs.container.ContainerServices;

public class MPlongLong extends MonitorPointHelper implements CBlongLongOperations {

	
	private longLongBlobData[] blobDataSeq_m =null;
	private CBlongLongPOA server;
	private ROlongLong property_m;
	
	

	public MPlongLong(Logger log, String propertyName, long archivingInterval, Property propertyRef, MonitorBlob mb) {
		super(log, propertyName, archivingInterval,  propertyRef, mb);
		server =new CBlongLongPOATie(this);
		monitorBlob_m.typeOfValue  = alma.TMCDB.longValueType.value;
		//setMonitorServant(server);
		this.blobDataSeq_m =new longLongBlobData[prealocSeqLen_m];
		seqLen_m = prealocSeqLen_m;
		try
		{
			property_m=ROlongLongHelper.narrow(propertyRef);
			//m_logger.info("no such Characteristic for"+propertyName);
			if(property_m.default_timer_trigger()==0){
			
				m_logger.info("Default_timer_trigger=0 in Property:"+propertyName);
			}
		}
		catch(Exception ex)
		{
			m_logger.info("no such Characteristic for"+ex.getMessage());
		}
		
		m_logger.info("INIZIALIZZATA COMPONENTE "+propertyName);
	}

	@Override
	public void working(long value, Completion c, CBDescOut desc) {
		m_logger.info("---->Working on:"+propertyName_m);
	    // Still place in current available buffer segments
		m_logger.info("--->Received:"+value);
	    if ( curSeqPos_m < seqLen_m )
	    {
	        // This log is commented because of operational constraints that are currently using 'debug' as operation log setting
	        //ACS_SHORT_LOG((LM_DEBUG, "Adding data to buffer"));
	        // Add data to current position
	    	longLongBlobData a = new longLongBlobData();
			a.value = value;
			a.time = c.timeStamp;
			blobDataSeq_m[curSeqPos_m] = a;
	        // Increment current position pointer
	    	m_logger.info("--->Received:"+value);
	        curSeqPos_m++;
	        // Increment initial position pointer if buffer is full
	        if (bufferFull)
	        {
	        	System.out.println("Data lost from buffer");
	            curSeqInit_m++;
	        }
	    }
	    else // Current available buffer segments are full
	    {	        
	        	m_logger.warning("No more data segments are allowed. Buffer is full");
	            // Define buffer as full
	            bufferFull = true;
	            // Increment buffer initial position
	            curSeqInit_m++;
	            // Reset buffer current position
	            curSeqPos_m = 0;
	            // Add data to current position
		    	longLongBlobData a = new longLongBlobData();
				a.value = value;
				a.time = c.timeStamp;
				blobDataSeq_m[curSeqPos_m] = a;
		        // Increment current position pointer
	            curSeqPos_m++;
	    }
	    
		
	}

	@Override
	public void fillSeq() {
		
		//super.fillSeq();
		
		synchronized(mutex) {
		
		try {
			if (curSeqInit_m == 0)
		    {
		        //blobDataSeq_m =new doubleBlobData[curSeqPos_m];
				longLongBlobData[] tmpBlobDataSeq = new longLongBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.info("1---> BlobDataSeq "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[i];
				}
				longLongBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		        //blobDataSeq_m = new doubleBlobData[seqLen_m];
		    }else {
		    	longLongBlobData[] tmpBlobDataSeq = new longLongBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.info("2---> BlobDataSeq "+i+" "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[(i+curSeqInit_m)%seqLen_m];
				}
				longLongBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		    }
		}catch (Exception e) {
			m_logger.severe("execption:"+e.getMessage());
		}
		    		
		}
		
		curSeqPos_m = 0;
	    curSeqInit_m = 0;
	    bufferFull = false;
	    //System.out.println("---> fillSeq Stop, any type="+monitorBlob_m.blobDataSeq.type()+" (doubleBlobDataSeqHelper.type()=)"+doubleBlobDataSeqHelper.type());
	}

	@Override
	public void done(long value, Completion c, CBDescOut desc) {
		
		m_logger.info("Done!");
	}
	
	@Override
	public void activate(ContainerServices containerServices_m) {
		try
		{
			monitorServant_m = containerServices_m.activateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException ex)
		{
			m_logger.severe("Problems activating servant:"+ex.getMessage());
		} catch (AcsJContainerServicesEx e) {
			m_logger.severe("Problems with Container services:"+e.getMessage());
		}
		
	}

	@Override
	public void deactivate(ContainerServices containerServices_m) {
		try
		{
			containerServices_m.deactivateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException | AcsJContainerServicesEx ex)
		{
			m_logger.severe("Problems with CORBA/Container services:"+ex.getMessage());
		}
		
	}


}
