package alma.TMCDB.MonitorCollectorImpl;

import java.util.logging.Logger;

import org.omg.CORBA.SystemException;
import alma.ACS.CBDescOut;
import alma.ACS.CBlongOperations;
import alma.ACS.CBlongPOA;
import alma.ACS.CBlongPOATie;
import alma.ACS.Property;
import alma.ACS.ROlong;
import alma.ACS.ROlongHelper;
import alma.ACSErr.Completion;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.longBlobData;
import alma.TMCDB.longBlobDataSeqHelper;
import alma.acs.container.ContainerServices;
import alma.acs.logging.AcsLogLevel;

public class MPlong extends MonitorPointHelper implements CBlongOperations {

	
	private longBlobData[] blobDataSeq_m =null;
	private CBlongPOA server;
	private ROlong property_m;
	
	

	public MPlong(Logger log, String propertyName, long archivingInterval, Property propertyRef, MonitorBlob mb) {
		super(log, propertyName, archivingInterval,  propertyRef, mb);
		server =new CBlongPOATie(this);
		monitorBlob_m.typeOfValue  = alma.TMCDB.longValueType.value;
		//setMonitorServant(server);
		this.blobDataSeq_m =new longBlobData[prealocSeqLen_m];
		seqLen_m = prealocSeqLen_m;
		try
		{
			property_m=ROlongHelper.narrow(propertyRef);
			//m_logger.info("no such Characteristic for"+propertyName);
			if(property_m.default_timer_trigger()==0){
			
				m_logger.log(AcsLogLevel.DEBUG,"Default_timer_trigger=0 in Property:"+propertyName);
			}
		}
		catch(Exception ex)
		{
			m_logger.warning("no such Characteristic:"+ex.getMessage());
		}
		
		m_logger.log(AcsLogLevel.DEBUG,"INIZIALIZZATA COMPONENTE "+propertyName);
	}

	@Override
	public void working(int value, Completion c, CBDescOut desc) {
		m_logger.log(AcsLogLevel.DEBUG,"---->Working on:"+propertyName_m);
	    // Still place in current available buffer segments
		m_logger.log(AcsLogLevel.DEBUG,"--->Received:"+value);
	    if ( curSeqPos_m < seqLen_m )
	    {
	        // This log is commented because of operational constraints that are currently using 'debug' as operation log setting
	        //ACS_SHORT_LOG((LM_DEBUG, "Adding data to buffer"));
	        // Add data to current position
	    	longBlobData a = new longBlobData();
			a.value = value;
			a.time = c.timeStamp;
			blobDataSeq_m[curSeqPos_m] = a;
	        // Increment current position pointer
	    	m_logger.info("Received:"+value);
	        curSeqPos_m++;
	        // Increment initial position pointer if buffer is full
	        if (bufferFull)
	        {
	        	m_logger.warning("Data lost from buffer");
	            curSeqInit_m++;
	        }
	    }
	    else // Current available buffer segments are full
	    {	        
	        	m_logger.warning("No more data segments are allowed. Buffer is full");
	            // Define buffer as full
	            bufferFull = true;
	            // Increment buffer initial position
	            curSeqInit_m++;
	            // Reset buffer current position
	            curSeqPos_m = 0;
	            // Add data to current position
		    	longBlobData a = new longBlobData();
				a.value = value;
				a.time = c.timeStamp;
				blobDataSeq_m[curSeqPos_m] = a;
		        // Increment current position pointer
	            curSeqPos_m++;
	    }
	    
		
	}

	@Override
	public void fillSeq() {
		
		super.fillSeq();
		
		synchronized(mutex) {
		
		try {
			m_logger.log(AcsLogLevel.DEBUG,"---------FILLING SEQ:"+propertyName_m);
			if (curSeqInit_m == 0)
		    {
		        //blobDataSeq_m =new doubleBlobData[curSeqPos_m];
				longBlobData[] tmpBlobDataSeq = new longBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.log(AcsLogLevel.DEBUG,"1---> BlobDataSeq "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[i];
				}
				longBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		        //blobDataSeq_m = new doubleBlobData[seqLen_m];
		    }else {
		    	longBlobData[] tmpBlobDataSeq = new longBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.log(AcsLogLevel.DEBUG,"2---> BlobDataSeq "+i+" "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[(i+curSeqInit_m)%seqLen_m];
				}
				longBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		    }
		}catch (Exception e) {
			m_logger.severe("execption:"+e.getMessage());
		}
		    		
		}
		
		curSeqPos_m = 0;
	    curSeqInit_m = 0;
	    bufferFull = false;
	    //System.out.println("---> fillSeq Stop, any type="+monitorBlob_m.blobDataSeq.type()+" (doubleBlobDataSeqHelper.type()=)"+doubleBlobDataSeqHelper.type());
	}

	@Override
	public void done(int value, Completion c, CBDescOut desc) {
		
		m_logger.info("Done!");
	}
	
	@Override
	public void activate(ContainerServices containerServices_m) {
		try
		{
			monitorServant_m = containerServices_m.activateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException ex)
		{
			m_logger.severe("Problems activating servant:"+ex.getMessage());
		} catch (AcsJContainerServicesEx e) {
			m_logger.severe("Problems with Container services:"+e.getMessage());
		}
		
	}

	@Override
	public void deactivate(ContainerServices containerServices_m) {
		try
		{
			containerServices_m.deactivateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException | AcsJContainerServicesEx ex)
		{
			m_logger.severe("Problems with CORBA/Container services:"+ex.getMessage());
		}
		
	}


}
