package alma.TMCDB.MonitorCollectorImpl;

import java.util.logging.Logger;

import org.jacorb.orb.ORB;
import org.jacorb.poa.POA;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.Servant;

import alma.ACS.CBDescOut;
import alma.ACS.CBdoubleHelper;
import alma.ACS.CBdoubleOperations;
import alma.ACS.CBdoublePOA;
import alma.ACS.CBdoublePOATie;
import alma.ACS.OffShoot;
import alma.ACS.Property;
import alma.ACS.ROdouble;
import alma.ACS.ROdoubleHelper;
import alma.ACSErr.Completion;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.TMCDB.MonitorBlob;
import alma.TMCDB.doubleBlobData;
import alma.TMCDB.doubleBlobDataHelper;
import alma.TMCDB.doubleBlobDataSeqHelper;
import alma.acs.container.ContainerServices;
import alma.acs.logging.AcsLogLevel;

public class MPdouble extends MonitorPointHelper implements CBdoubleOperations {

	
	private doubleBlobData[] blobDataSeq_m =null;
	private CBdoublePOA server;
	private ROdouble property_m;
	
	

	public MPdouble(Logger log, String propertyName, long archivingInterval, Property propertyRef, MonitorBlob mb) {
		super(log, propertyName, archivingInterval,  propertyRef, mb);
		server =new CBdoublePOATie(this);
		monitorBlob_m.typeOfValue  = alma.TMCDB.doubleValueType.value;
		//setMonitorServant(server);
		this.blobDataSeq_m =new doubleBlobData[prealocSeqLen_m];
		seqLen_m = prealocSeqLen_m;
		try
		{
			property_m=ROdoubleHelper.narrow(propertyRef);
			//m_logger.info("no such Characteristic for"+propertyName);
			if(property_m.default_timer_trigger()==0){
			
				m_logger.info("Default_timer_trigger=0 in Property:"+propertyName);
			}
		}
		catch(Exception ex)
		{
			m_logger.info("no such Characteristic for"+ex.getMessage());
		}
		
		m_logger.info("INIZIALIZZATA COMPONENTE "+propertyName);
	}

	@Override
	public void working(double value, Completion c, CBDescOut desc) {
		m_logger.log(AcsLogLevel.DEBUG,"---->Working on:"+propertyName_m);
	    // Still place in current available buffer segments
		m_logger.log(AcsLogLevel.DEBUG,"--->Received:"+value);
	    if ( curSeqPos_m < seqLen_m )
	    {
	        // This log is commented because of operational constraints that are currently using 'debug' as operation log setting
	        //ACS_SHORT_LOG((LM_DEBUG, "Adding data to buffer"));
	        // Add data to current position
	    	doubleBlobData a = new doubleBlobData();
			a.value = value;
			a.time = c.timeStamp;
			blobDataSeq_m[curSeqPos_m] = a;
			//blobDataSeq_m[curSeqPos_m].value = value;
			//blobDataSeq_m[curSeqPos_m].time = c.timeStamp;
	        // Increment current position pointer
	    	//System.out.print("--->Received:"+value);
	        curSeqPos_m++;
	        // Increment initial position pointer if buffer is full
	        if (bufferFull)
	        {
	        	m_logger.warning("Data lost from buffer");
	            curSeqInit_m++;
	        }
	    }
	    else // Current available buffer segments are full
	    {
	        // Another segment can be created
	        if ( seqLen_m < (prealocSeqLen_m))
	        {
	        	m_logger.log(AcsLogLevel.DEBUG,"Creating new buffer segment and adding data to it");
	            // Create new segment
	            seqLen_m = seqLen_m + prealocSeqLen_m;
	            // blobDataSeq_m.length(seqLen_m);
	            // Add data to current position
	            doubleBlobData a = new doubleBlobData();
				a.value = value;
				a.time = c.timeStamp;
				blobDataSeq_m[curSeqPos_m] = a;
	            //blobDataSeq_m[curSeqPos_m].value = value;
		        //blobDataSeq_m[curSeqPos_m].time = c.timeStamp;
	            // Increment current position pointer
				m_logger.fine("-->Received:"+value);
	            curSeqPos_m++;
	        }
	        else // No more segments allowed
	        {
	        	m_logger.warning("No more data segments are allowed. Buffer is full");
	            // Define buffer as full
	            bufferFull = true;
	            // Increment buffer initial position
	            curSeqInit_m++;
	            // Reset buffer current position
	            curSeqPos_m = 0;
	            // Add data to current position
	            blobDataSeq_m[curSeqPos_m].value = value;
		        blobDataSeq_m[curSeqPos_m].time = c.timeStamp;
		        // Increment current position pointer
	            curSeqPos_m++;
	        }
	    }
		
	}

	@Override
	public void fillSeq() {
		
		//super.fillSeq();
		
		synchronized(mutex) {
		
		try {
			m_logger.log(AcsLogLevel.DEBUG,"---------FILLING SEQ:"+propertyName_m);
			if (curSeqInit_m == 0)
		    {
		        //blobDataSeq_m =new doubleBlobData[curSeqPos_m];
				doubleBlobData[] tmpBlobDataSeq = new doubleBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.log(AcsLogLevel.DEBUG,"1---> BlobDataSeq "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[i];
				}
				doubleBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		        //blobDataSeq_m = new doubleBlobData[seqLen_m];
		    }else {
		    	doubleBlobData[] tmpBlobDataSeq = new doubleBlobData[curSeqPos_m];
				for (int i = 0; i < curSeqPos_m; i++) {
					m_logger.log(AcsLogLevel.DEBUG,"2---> BlobDataSeq "+i+" "+blobDataSeq_m[i].time+" "+blobDataSeq_m[i].value);
					tmpBlobDataSeq[i] = blobDataSeq_m[(i+curSeqInit_m)%seqLen_m];
				}
				doubleBlobDataSeqHelper.insert(monitorBlob_m.blobDataSeq, tmpBlobDataSeq);
		    }
		}catch (Exception e) {
			m_logger.severe("execption:"+e.getMessage());
		}
		    		
		}
		
		curSeqPos_m = 0;
	    curSeqInit_m = 0;
	    bufferFull = false;
	    //System.out.println("---> fillSeq Stop, any type="+monitorBlob_m.blobDataSeq.type()+" (doubleBlobDataSeqHelper.type()=)"+doubleBlobDataSeqHelper.type());
	}

	@Override
	public void done(double value, Completion c, CBDescOut desc) {
		
		m_logger.info("Done!");
	}
	
	@Override
	public void activate(ContainerServices containerServices_m) {
		try
		{
			monitorServant_m = containerServices_m.activateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException ex)
		{
			m_logger.severe("Problems activating servant:"+ex.getMessage());
		} catch (AcsJContainerServicesEx e) {
			m_logger.severe("Problems with Container services:"+e.getMessage());
		}
		
	}

	@Override
	public void deactivate(ContainerServices containerServices_m) {
		try
		{
			containerServices_m.deactivateOffShoot(server);
	                // At this point ref count of monitorServant_m will be 2
		}
		catch(SystemException | AcsJContainerServicesEx ex)
		{
			m_logger.severe("Problems with CORBA/Container services:"+ex.getMessage());
		}
		
	}

}
