package astri.minimal.MinimalComponentImpl;

import java.util.logging.Logger;

import alma.ACS.ROdouble;
import alma.ACS.ROdoubleHelper;
import alma.ACS.ROdoublePOATie;
import alma.ACS.impl.CharacteristicComponentImpl;
import alma.ACS.impl.ROdoubleImpl;
import alma.ACS.jbaci.DataAccess;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;
import astri.minimal.MinimalComponentOperations;
import astri.minimal.DataAccess.RandomDataAccessSupport;

/**
 * @author Claudio Tanci
 *
 */
public class MinimalComponentImpl extends CharacteristicComponentImpl implements
		MinimalComponentOperations {
	
	private ContainerServices m_containerServices;
	private Logger m_logger;

	protected ROdouble fooProp;
	protected DataAccess fooDataAccess;
	
	protected ROdouble barProp;
	protected DataAccess barDataAccess;
	
	/* (non-Javadoc)
	 * @see astri.minimal.MinimalComponentOperations#foo()
	 */
	@Override
	public ROdouble foo() {
		return fooProp;
	}
	
	/* (non-Javadoc)
	 * @see astri.minimal.MinimalComponentOperations#foo()
	 */
	@Override
	public ROdouble bar() {
		return barProp;
	}
	
	@Override
	public String sayHello() {
		m_logger.info("sayHello called");
		String msg = "Hello";
		return msg;
	}

	/* (non-Javadoc)
	 * @see alma.ACS.impl.CharacteristicComponentImpl#initialize(alma.acs.container.ContainerServices)
	 */
	@Override
	public void initialize(ContainerServices containerServices)
			throws ComponentLifecycleException {
		
		m_containerServices = containerServices;
		m_logger = m_containerServices.getLogger();
		
		m_logger.info("inizialize() called...");
		
		super.initialize(containerServices);
		
		try {
//			fooDataAccess = new MemoryDataAccess();
			fooDataAccess = new RandomDataAccessSupport("foo");
			ROdoubleImpl fooImpl = new ROdoubleImpl("foo", this, fooDataAccess);
			ROdoublePOATie fooTie = new ROdoublePOATie(fooImpl);
			fooProp = ROdoubleHelper.narrow(this.registerProperty(fooImpl, fooTie));

			barDataAccess = new RandomDataAccessSupport("bar");
			ROdoubleImpl barImpl = new ROdoubleImpl("bar", this, barDataAccess);
			barProp = ROdoubleHelper.narrow(this.registerProperty(barImpl, new ROdoublePOATie(barImpl)));
			
		} catch (Throwable th) {
			throw new ComponentLifecycleException("Failed to create properties.", th); 
		}
	}

	/* (non-Javadoc)
	 * @see alma.ACS.impl.CharacteristicComponentImpl#cleanUp()
	 */
	@Override
	public void cleanUp() throws AcsJComponentCleanUpEx {
		// TODO Auto-generated method stub
		super.cleanUp();
	}
}
