CPS.LMC project
===========================

[![Documentation Status](https://readthedocs.org/projects/csp-lmc/badge/?version=latest)](https://developer.skatelescope.org/projects/csp-lmc/en/latest/?badge=latest)
[![coverage report](https://gitlab.com/ska-telescope/csp-lmc/badges/master/coverage.svg)](https://ska-telescope.gitlab.io/csp-lmc/)
[![pipeline status](https://gitlab.com/ska-telescope/csp-lmc/badges/master/pipeline.svg)](https://gitlab.com/ska-telescope/csp-lmc/pipelines)

## Table of contents
* [Introduction](#introduction)
* [Repository](#repository)
* [CSP.LMC Common Package](#csp-lmc-common)
    * [Create the CSP.LMC Common Software python package](#python-package)
* [CSP_Mid LMC](#mid-csp-mid-lmc)
    * [Running tests](#running-tests) 
* [CSP_Low LMC](#csp-low-lmc)
    * [Run in containers](#how-to-run-in-docker-containers)
* [Known bugs](#known-bugs)
* [Troubleshooting](#troubleshooting)
* [License](#license)

## Introduction

General requirements for the monitor and control functionality are the same for both the SKA MID and LOW telescopes. <br/>
In addition, two of three other CSP Sub-elements, namely the `Pulsar Search` and the `Pulsar Timing`, have the same functionality and use the same design in both telescopes.<br/>
Functionality common to `CSP_Low.LMC` and `CSP_Mid.LMC` includes: communication framework, logging, archiving, alarm generation, sub-
arraying, some of the functionality related to handling observing mode changes, `Pulsar Search` and
`Pulsar Timing`, and to some extent Very Long Baseline Interferometry (`VLBI`).<br/>
The difference between `CSP_Low.LMC` and `CSP_Mid.LMC` is mostly due to different receivers (dishes vs stations) and
different `CBF` functionality and design.<br/>
To maximize code reuse, the software common to `CSP_Low.LMC` and `CSP_Mid.LMC` is developed by the work
package `CSP_Common.LMC` and provided to work packages `CSP_Low.LMC` and `CSP_Mid.LMC`, to
be used as a base for telescope specific `CSP.LMC` software.

## Repository organization

To simplify the access at the whole  CSP.LMC software, the  `CSP_Common.LMC`, `CSP_Low.LMC` and `CSP_Mid.LMC` software packages are hosted in the same SKA GitLab repository, named `CSP.LMC`.<br/>
The `CSP.LMC` repository is organized in three main folders, `csp-lmc-common`, `csp-low-lmc` and `csp-mid-lmc`, each presenting
the same organization:

* project source: contains the specific project TANGO Device Class files
* pogo: contains the POGO files of the TANGO Device Classes of the project 
* docker: containes the `docker`, `docker-compose` and `dsconfig` configuration files as well as the Makefile to generate the docker image and run the tests.
* tests: contains the test

To get a local copy of the repository:

```bash
git clone https://gitlab.com/ska-telescope/csp-lmc.git
```
## Prerequisities

* A TANGO development environment properly configured, as described in [SKA developer portal](https://developer.skatelescope.org/en/latest/tools/tango-devenv-setup.html)

* [SKA Base classes](https://gitlab.com/ska-telescope/lmc-base-classes)
* 
## CSP_Mid.LMC

The TANGO devices of the CSP_Mid.LMC prototype run in a containerised environment.
Currently only a limitated number of CSP_Mid.LMC and CBF_Mid.LMC devices are run in Docker containers:

* the MidCspMaster and MID CbfMaster
* the MidCspCapabilityMonitor devices
* two instances of the CSP_Mid and CBF_Mid subarrays
* four instances of the Very Coarse Channelizer (VCC) devices
* four instance of the Frequency Slice Processor (FPS) devices
* two instances of the TM TelState Simulator devices

The Docker containers running the CBF_Mid devices are instantiated pulling the `mid-cbf-mcs:test` project image from the [Nexus repository](https://nexus.engageska-portugal.pt). <br/>
The CSP_Mid.LMC project provides a [Makefile](Makefile) to start the system containers and the tests.<br/>
The containerised environment relies on three YAML configuration files:

* `mid-csp-tangodb.yml`
* `mid-csp-lmc.yml`
* `mid-cbf-mcs.yml`

Each file includes the stages to run the the `CSP_Mid.LMC TANGO DB`, the `CSP_Mid.LMC` devices and `Mid-CBF.LMC` TANGO Devices inside separate docker containers.<br/>
These YAML files are used by `docker-compose` to run both the CSP_Mid.LMC and CBF.LMC TANGO device
instances, that is, to run the whole `CSP_Mid.LMC` prototype.>br\>
In this way, it's possible to execute some preliminary integration tests, as for example the assignment/release of receptors to a `CSP_Mid Subarray` and its configuration to execute a scan in Imaging mode.<br/>
The `CSP_Mid.LMC` and `Mid-CBF.LMC TANGO` Devices are registered with the same TANGO DB, and its 
configuration is performed via the `dsconfig` TANGO Device provided by the [dsconfig project](https://gitlab.com/MaxIV-KitsControls/lib-maxiv-dsconfig). <br />
This device use a JSON file to configure the TANGO DB. <br/>
The `CSP_Mid.LMC` and `Mid-CBF.LMC` projects provide its own  JSON file:
[midcsplmc\_dsconfig.json](csp-lmc/csp-lmc-mid/csp-lmc-mid/docker/config/midcsplmc_dsconfig.json) and [midcbf\_dsconfig.json](sp-lmc/csp-lmc-mid/csp-lmc-mid/docker/config/midcbf_dsconfig.json)  

To run the `CSP_Mid.LMC` prototype inside Docker containers,issue the command:

```bash
make up
```
from the `docker` of the project directory. At the end of the procedure the command

<pre><code>docker ps</code></pre>
shows the list of the running containers:
```
mid-csp-lmc-tangodb:            the MariaDB database with the TANGO database tables  
mid-csp-lmc-databaseds:         the TANGO DB device server
mid-csp-lmc-cbf_dsconfig:       the dsconfig container to configure CBF.LMC devices in the TANGO DB
mid-csp-lmc-cbf_dsconfig:       the dsconfig container to configure CSP.LMC devices in the TANGO DB
mid-csp-lmc-midcspmaster:       the CspMaster TANGO device
mid-csp-lmc-midcapabilitymonitor: the monitor devices of the CSP_Mid.LMC Capabilities
mid-csp-lmc-midcspsubarray[01-02]: two instances of the CspSubarray TANGO device
mid-csp-lmc-rsyslog-csplmc:     the rsyslog container for the CSP.LMC devices
mid-csp-lmc-rsyslog-cbf :       the rsyslog container for the CBF.LMC devices
mid-csp-lmc-cbfmaster:          the CbfMaster TANGO device
mid-csp-lmc-cbfsubarray[01-02]: two instances of the CbfSubarray TANGO device  
mid-csp-lmc-vcc[001-004]:       four instances of the Mid-CBF VCC TANGO device 
mid-csp-lmc-fsp[01-04]:         four instances of the Mid-CBF FSP TANGO device      
mid-csp-lmc-tmcspsubarrayleafnodetest/2: two instances of the TelState TANGO Device 
                                simulator provided by the CBF project to support scan
                                configuration for Subarray1/2
```
To stop and removes the Docker containers, issue the command
<pre><code>make down</code></pre>
from the prototype root directory.

__NOTE__
>Docker containers are run with the `--network=host` option.
In this case there is no isolation between the host machine and the containers. <br/>
This means that the TANGO DB running in the container is available on port 10000 of the host machine. <br />
Running `jive` on the local host, the `CSP.LMC` and `Mid-CBF.LMC` TANGO Devices registered with the TANGO DB (running in a docker container)
can be visualized and explored.

## Running tests

The project includes a set of tests for the `MidCspMaster` and `MidCspSubarray` TANGO Devices that can be found in the project `tests` folder.<br/>
To run the test on the local host issue the command

<code><pre>make test</pre></code>
from the `docker` project directory.<br/>
The test are run in docker containers providing the proper environment setup and isolation.

## Known bugs


## Troubleshooting


## License
See the LICENSE file for details.

