# -*- coding: utf-8 -*-
#
# This file is part of the CspCapabilityMonitor project
#
# INAF, SKA Telescope
#
# Distributed under the terms of the GPL license.
# See LICENSE.txt for more info.

""" CSP.LMC Common  Class

CSP.LMC Common Class designed to monitoring the SCM
attributes of the CSP Capabilities: SearchBeams, TimingBeams,
VlbiBeams, Receptors/Stations.
"""

# PyTango imports
import tango
from tango import DebugIt
from tango.server import run
from tango.server import Device, DeviceMeta
from tango.server import attribute, command
from tango.server import device_property
from tango import AttrQuality, DispLevel, DevState
from tango import AttrWriteType, PipeWriteType
from SKABaseDevice import SKABaseDevice
# Additional import
# PROTECTED REGION ID(CspCapabilityMonitor.additionnal_import) ENABLED START #
# PROTECTED REGION END #    //  CspCapabilityMonitor.additionnal_import

__all__ = ["CspCapabilityMonitor", "main"]


class CspCapabilityMonitor(SKABaseDevice):
    """
    CSP.LMC Common Class designed to monitoring the SCM
    attributes of the CSP Capabilities: SearchBeams, TimingBeams,
    VlbiBeams, Receptors/Stations.

    **Properties:**

    - Device Property
    
    
    
    
    
        CapabilityDevices
            - The list of the CSP Capability devices FQDNs monitored\nby the instance.
            - Type:'DevVarStringArray'
    
    """
    __metaclass__ = DeviceMeta
    # PROTECTED REGION ID(CspCapabilityMonitor.class_variable) ENABLED START #
    # PROTECTED REGION END #    //  CspCapabilityMonitor.class_variable

    # -----------------
    # Device Properties
    # -----------------






    CapabilityDevices = device_property(
        dtype='DevVarStringArray',
    )

    # ----------
    # Attributes
    # ----------











    numOfUnassignedIDs = attribute(
        dtype='DevUShort',
    )

    capabilityState = attribute(
        dtype=('DevState',),
        max_dim_x=1500,
        label="Capability State",
        doc="Report the State of the capabilities.",
    )

    capabilityHealthState = attribute(
        dtype=('DevUShort',),
        max_dim_x=1500,
    )

    capabilityAdminMode = attribute(
        dtype=('DevUShort',),
        access=AttrWriteType.READ_WRITE,
        max_dim_x=1500,
    )

    capabilityObsState = attribute(
        dtype=('DevUShort',),
        max_dim_x=1500,
    )

    unassignedIDs = attribute(
        dtype=('DevUShort',),
        max_dim_x=1500,
    )

    capabilityAddresses = attribute(
        dtype=('DevString',),
        max_dim_x=1500,
        label="CSP.LMC Capability devices FQDNs",
        doc="The FQDNs of the CSP.LMC Capability devices: SearchBeams, TimingBeams, VlbiBeams,\nReceptors (MID instance), Stations (LOW instance)",
    )

    membership = attribute(
        dtype=('DevUShort',),
        max_dim_x=1500,
        label="Capabiity sub-array affilitiation",
    )

    # ---------------
    # General methods
    # ---------------

    def init_device(self):
        """Initialises the attributes and properties of the CspCapabilityMonitor."""
        SKABaseDevice.init_device(self)
        # PROTECTED REGION ID(CspCapabilityMonitor.init_device) ENABLED START #
        # PROTECTED REGION END #    //  CspCapabilityMonitor.init_device

    def always_executed_hook(self):
        """Method always executed before any TANGO command is executed."""
        # PROTECTED REGION ID(CspCapabilityMonitor.always_executed_hook) ENABLED START #
        # PROTECTED REGION END #    //  CspCapabilityMonitor.always_executed_hook

    def delete_device(self):
        """Hook to delete resources allocated in init_device.

        This method allows for any memory or other resources allocated in the
        init_device method to be released.  This method is called by the device
        destructor and by the device Init command.
        """
        # PROTECTED REGION ID(CspCapabilityMonitor.delete_device) ENABLED START #
        # PROTECTED REGION END #    //  CspCapabilityMonitor.delete_device
    # ------------------
    # Attributes methods
    # ------------------

    def read_numOfUnassignedIDs(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.numOfUnassignedIDs_read) ENABLED START #
        """Return the numOfUnassignedIDs attribute."""
        return 0
        # PROTECTED REGION END #    //  CspCapabilityMonitor.numOfUnassignedIDs_read

    def read_capabilityState(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityState_read) ENABLED START #
        """Return the capabilityState attribute."""
        return (PyTango.DevState.UNKNOWN,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityState_read

    def read_capabilityHealthState(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityHealthState_read) ENABLED START #
        """Return the capabilityHealthState attribute."""
        return (0,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityHealthState_read

    def read_capabilityAdminMode(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityAdminMode_read) ENABLED START #
        """Return the capabilityAdminMode attribute."""
        return (0,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityAdminMode_read

    def write_capabilityAdminMode(self, value):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityAdminMode_write) ENABLED START #
        """Set the capabilityAdminMode attribute."""
        pass
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityAdminMode_write

    def read_capabilityObsState(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityObsState_read) ENABLED START #
        """Return the capabilityObsState attribute."""
        return (0,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityObsState_read

    def read_unassignedIDs(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.unassignedIDs_read) ENABLED START #
        """Return the unassignedIDs attribute."""
        return (0,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.unassignedIDs_read

    def read_capabilityAddresses(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.capabilityAddresses_read) ENABLED START #
        """Return the capabilityAddresses attribute."""
        return ('',)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.capabilityAddresses_read

    def read_membership(self):
        # PROTECTED REGION ID(CspCapabilityMonitor.membership_read) ENABLED START #
        """Return the membership attribute."""
        return (0,)
        # PROTECTED REGION END #    //  CspCapabilityMonitor.membership_read


    # --------
    # Commands
    # --------

# ----------
# Run server
# ----------


def main(args=None, **kwargs):
    # PROTECTED REGION ID(CspCapabilityMonitor.main) ENABLED START #
    return run((CspCapabilityMonitor,), args=args, **kwargs)
    # PROTECTED REGION END #    //  CspCapabilityMonitor.main

if __name__ == '__main__':
    main()
