function unwr3(fconf)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  unwr3.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   Implementation of the unwrapping algorithm described in:
%            Juarez-Salazar, Robledo-Sanchez, and Guerrero-Sanchez
%            "Phase-unwrappingalgorithm by a rounding-least-squares
%            approach quick look of SRT holography raw-data"
%            Optical Engineering 53(2), 024102 (February 2014)
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% unwr3.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 load phase.dat
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 I=eye(mp);
%
 L=diag(-ones(mp,1),0)+diag(ones(mp-1,1),1);
 L=L(1:mp-1,:);
% 
 A=B=L'*L;
 [U,S,V]=svd(B);
 s=diag(S);
 C=-(round(e2/(2.0*pi)*L')*L+L'*round(L*e2/(2.0*pi)));
 D=C*U;
 K=zeros(mp,mp);
 for i=1:mp
  k=inv(A+s(i)*I)*D(:,i);
  K(:,i)=k;
 end
%
 K=round(K*U');
 u0=e2+2.0*pi*K;
 u0(blk)=0;
% 
 figure(1);
 imagesc(u0);
 axis('square');
 colormap('gray');
 colorbar;
 title('unwrapped map');
 save unwr.dat u0 blk
end
%  
