function m2=mresize(m1,r0,r1,mp,ca)
 [b blk]=mask(r0,r1,mp);
 n0=rows(m1);
 xx=1:n0;
 x=linspace(1,n0,mp);
 y=x';
 m2=interp2(xx,xx,m1,x,y);
 m2=m2.*b;
 imagesc(m2);
 caxis([-ca ca]);
 axis('square');
 colormap('jet');
 colorbar;
end
 
function [b blk]=mask(r0,r1,mp)
 b=ones(mp,mp);
 c=ones(mp,mp).*(1:mp);
 r=transpose(c);
 if(r0)
   i1=find(sqrt((r-mp/2).^2+(c-mp/2).^2)<=r0);
   b(i1)=0;
 end  
 if(r1)
  i1=find(sqrt((r-mp/2).^2+(c-mp/2).^2)>r1);
  b(i1)=0;
 end
 blk=find(b==0);
%
end