function uv(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  uv.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% uv.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
 load azel.txt;
 az=azel(:,1);
 el=azel(:,2);
 e_re=azel(:,3);
 e_im=azel(:,4);
 tp=sqrt(azel(:,5));
 azel=[];

%%%%%%%%%%%%%%%%%%  uv transformation %%%%%%%%%%%%%%%%%%%%%
%
 az0=azcut(1);
 el0=elcut(1);

 x=cosd(el+el0).*sind(az+az0);
 y=cosd(el+el0).*cosd(az+az0);
 z=sind(el+el0);
 
 xyz=transpose([x y z]);
 
 P = -az0;
 T = el0-90;
 
 A1 = [1 0 0; 0 cosd(T) sind(T); 0 -sind(T) cosd(T)];
 A2 = [cosd(P) sind(P) 0;-sind(P) cosd(P) 0; 0 0 1];
 uvw=A1*A2*xyz;

 u1=uvw(1,:);
% cambio il segno di v1
 v1=-uvw(2,:);
 
%
% figure(10); plot(u1,v1,'.');
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    
 du=lambda/D*k0;
 uu=min(u1):du:max(u1);
 vv=min(v1):du:max(v1);
%  
 [u,v] = meshgrid (uu,vv);
%
 er=griddata (u1,v1,e_re,u,v);
 i0=find(isnan(er));
 er(i0)=0.0;
%  
 ei=griddata (u1,v1,e_im,u,v);
 i0=find(isnan(ei));
 ei(i0)=0.0;
 %
 tp=griddata (u1,v1,tp,u,v);
 i0=find(isnan(tp));
 tp(i0)=0.0;
%
% 

 figure(1);
 emod=abs(er+i*ei);
 emod=emod/max(max(emod));
 emod=20*log10(emod);
 imagesc(uu,vv,emod);
 axis('square');
 colorbar;
 xlabel('u');
 ylabel('v');
 title('HFF');
%print -dpng preproc.png

 [pr0 pc0]=find(emod==0);
 [nr0 nc0]=size(emod);
 z=zeros(mp,mp);
 z(mp/2-pr0:mp/2-pr0+nr0-1,mp/2-pc0:mp/2-pc0+nc0-1)=er;
 er=z;
 
 z=zeros(mp,mp);
 z(mp/2-pr0:mp/2-pr0+nr0-1,mp/2-pc0:mp/2-pc0+nc0-1)=ei;
 ei=z;
 
 
 figure(2);
 emod=tp;
 emod=emod/max(max(emod));
 emod=20*log10(emod);
 imagesc(uu,vv,emod);
%   imagesc(emod);
 axis('square');
 colorbar;
 xlabel('u');
 ylabel('v');
 title('Total Power');
   
 z=zeros(mp,mp);
 z(mp/2-pr0:mp/2-pr0+nr0-1,mp/2-pc0:mp/2-pc0+nc0-1)=tp;
 tp=z;
 
%   pr0=mp/2-fix(size(er)(1)/2);
%   pc0=mp/2-fix(size(er)(2)/2);
%   z=zeros(mp,mp);
%   z(pr0:pr0+size(er)(1)-1,pc0:pc0+size(er)(2)-1)=er;
%   er=z;
%   z=zeros(mp,mp);
%   z(pr0:pr0+size(ei)(1)-1,pc0:pc0+size(ei)(2)-1)=ei;
%   ei=z;
%
 save uuvv.dat er ei tp
%  
end
 
