function preproc(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  preproc.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% preproc.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

 [az el tp c04 c05 c06 c07 c08 c09 c10 c11 c12 c13]=textread(filename,'%f %f %f %f %f %f %f %f %f %f %f %s %s');

 er=c06./sqrt(c04);
 ei=c07./sqrt(c05);

 i0=find((az>azcut(1)-azcut(2))&(az<azcut(1)+azcut(2)) & (el>elcut(1)-elcut(2))&(el<elcut(1)+elcut(2)));
 q=[az(i0),el(i0),er(i0),ei(i0)];
 
 az=az(i0);
 el=el(i0);
 e_re=er(i0);
 e_im=ei(i0);

 da=diff(az);
 da=[0;da];
 de=diff(el);
 de=[0;de];
 figure(1);
 xlabel('Points');
   
 flag=zeros(length(az),1); % all'inizio sono tutti flaggati a zero, cioe' sono da scartare 
 printf('********************************\n'); 
 
%   if(!exist('scn','var'))
%     scn='az';
%   end
 switch(scn)
  case('az')
   printf('Azimuth scan\n');
   for j1=1:size(dam)(1)
    i0=find((da>dam(j1,1))&(da<dam(j1,2)));
    flag(i0)=1; % quelli flaggati a 1 sono quelli che appartengono alle scansioni
   end  
   ylabel('Azimuth speed (deg/s)');
   plot(da,'o');
  case('el')
   printf('Elevation scan\n');
   for j1=1:size(dam)(1)
    i0=find((de>dam(j1,1))&(de<dam(j1,2)));
    flag(i0)=1; % quelli flaggati a 1 sono quelli che appartengono alle scansioni
   end  
   ylabel('Elevation speed (deg/s)');
   plot(de,'o');
  otherwise
   printf('error: invalid scn parameter!\n');
   return;
 end
%
 i0=find((flag==0)&(az>azcut(1)-azcut(3))&(az<azcut(1)+azcut(3))&(el>elcut(1)-elcut(3))&(el<elcut(1)+elcut(3)));  
 flag(i0)=2;
% 
 i1=find(flag==1);
 el1=el(i1);
 az1=az(i1);
 figure(2);
 plot(az1,el1,'.g;map points;')
 title('AzEl map')
 hold on;
 i2=find(flag==0);
 el2=el(i2);
 az2=az(i2);
 plot(az2,el2,'*r;outliers;')
 i3=find(flag==2);

 el3=el(i3);
 az3=az(i3);
 plot(az3,el3,'ob;sat points;')
 hold off;
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 e_re_s=e_re(i3);
 e_im_s=e_im(i3); 

 n=length(az3);
 n1=length(az1);
 x=(1:n)';
 y=(linspace(1,n,n1))';
%   x=x/max(x);
%   y=y/max(y);
 
%ph1=atan(e_im_s./e_re_s);
 ph1=atan2(e_im_s,e_re_s);
 ph3=movave(ph1,nma);
 figure(3);
 plot(180/pi*ph1,'.1;source phase (deg);');
 hold on;
 plot(180/pi*ph3,'3','LineWidth',4);
 hold off;
 grid minor on;
%print -dpng source_phase.png
 ph2=interp1(x,ph3,y);   
 
 amp1=sqrt(e_im_s.^2+ e_re_s.^2);
 maxamp1=max(max(amp1));
 amp1=amp1/maxamp1; 
 amp3=movave(amp1,nma);
 figure(4);
 plot(x,amp1,'.1;source amp;');
 hold on;
 plot(x,amp3,'3','LineWidth',4);
 hold off;
 grid minor on;
%print -dpng source_amp.png
 amp2=interp1(x,amp3,y);   
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 az=az1;
 el=el1;
 e_re=e_re(i1);
 e_im=e_im(i1);
 tp=tp(i1);
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   figure(4);
%   plot(e_re,'.1;real;');
%   hold on;
%   plot(e_im,'.2;imag;');
%   hold off;
%   grid minor on;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 src_pos=5;
 switch(src_pos)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  case(1)
   n=length(az3);
   n1=length(az1);
   x=(1:n)';
   y=(linspace(1,n,n1))';
   A=[x.^2 x ones(n,1)];
   B=[y.^2 y ones(n1,1)]; 
   z=A\az3;
   az0=B*z;  
   z=A\el3;
   el0=B*z;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 case(2)
   az0=mean(az3);
   el0=mean(el3);
 case(3)
   az0=mean(az);
   el0=mean(el);
 case(4)
   n=length(az3);
   x=(1:n)';
   A=[x.^2 x ones(n,1)];
   z=A\az3;
   az4=A*z;  
   z=A\el3;
   el4=A*z;
   az0=mean(az4);
   el0=mean(el4);
 case(5)
   az0=azcut(1);
   el0=elcut(1);
 otherwise
   az0=0;
   el0=0;
 end 
 az=az-az0;
 el=el-el0;
 
 ph_std=std(ph1-ph3);
 am_std=std(amp1-amp3);
 snr0=mean(amp1)/am_std;
 
 printf('Scan points=%d\n',size(az)(1)); 
 printf('On source points=%d\n',size(az3)(1)); 
 printf('az0=%f, el0=%f (deg)\n',az0,el0); 
 printf('RMS_phase=%f (deg)\n',180/pi*ph_std); 
 printf('phase_err=%f (um)\n',1E6*ph_std*lambda/6/pi); 
 printf('RMS_ampl=%f\n',am_std); 
 printf('SNR=%f\n',snr0);
 printf('********************************\n'); 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   
 if (source)
  amp1=sqrt(e_re.^2+e_im.^2);
  ph1=atan2(e_im,e_re);
  ph1=ph1-ph2;
  amp1=amp1./amp2;
% 
  e_re=amp1.*cos(ph1);
  e_im=amp1.*sin(ph1);
 end
%  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 out=[az el e_re e_im tp];
 save -ascii azel.txt out
end
 
function y=movave(x,n)
 m=length(x);
 y=zeros(n,1);
 for i=n:m-n
  y(i)=mean(x(i-n+1:i+n));
 end
 y(1:n-1)=y(n);
 y(m-n+1:m)=y(m-n);
end
