function phase(fconf)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  phase.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% phase.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 m=mp;

 load uuvv.dat;
 k=2*pi/lambda;
 a=exp(i*2.0*k*F);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 T=er+i*ei;
 if(sgm>0)
 % smoothing gaussiano
  uu=-mp/2:mp/2-1;
  vv=uu;
  [u,v] = meshgrid (uu,vv);
  z=exp(-(u.^2+v.^2)/(sgm^2));
  z=z/max(max(z));
  T=T.*z;
 end
%save T.dat T
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 T=ifftshift(T);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 w=ifft2(T); 
 y=a.*w;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

 r=abs(y); %sqrt(y.*conj(y));
%f=[r(m/2+1:m,m/2+1:m) r(m/2+1:m,1:m/2); r(1:m/2,m/2+1:m) r(1:m/2,1:m/2)];
 f=fftshift(r);
 
 sc=sr=0;
 gf=~(pc&pr);
 if(gf)
  [mu sigma x1 y1 y2]=gfit(f,m,trs);
  figure(1);
  plot(x1,y1,'ro');hold on;
  plot(x1,y2);hold off;
  xlabel('columns (px)');
  ylabel('Gaussian fit (%)');
  axis([1 m 0 110]);
% pc=round(pc+mp/2-mu);
  pc=round(mp/2-mu);
  sc=sigma;

  [mu sigma x1 y1 y2]=gfit(f',m,trs);
  figure(2);
  plot(x1,y1,'ro');hold on;
  plot(x1,y2);hold off;
  xlabel('raws (px)');
  ylabel('Gaussian fit (%)');
  axis([1 m 0 110]);
% pr=round(pr+mp/2-mu);
  pr=round(mp/2-mu);
  sr=sigma;
 end
  
 if(pc)
  f1=[zeros(m,pc) f(:,abs(pc):m-1) zeros(m,-pc)];
 else
  f1=f;
 end
 if(pr)
  f=[zeros(pr,m) ; f1(1:m-abs(pr),:) ; zeros(-pr,m)];
 end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 dx=D/(mp-1)/k0;
 printf('********************************\n');
 printf('dx=%f (m/px)\n',dx);
 printf('r0=%f (m)\n',r0*dx);
 printf('r1=%f (m)\n',r1*dx);
 printf('dfx=%f, %d (m, px)\n',pc*dx,pc);
 printf('dfy=%f, %d (m, px)\n',pr*dx,pr); 
 printf('df=%f (m)\n',sqrt(pr^2+pc^2)*dx); 
 if(gf)
  printf('sigma_x=%d (px)\n',round(sc)); 
  printf('sigma_y=%d (px)\n',round(sr));  
 end 
 printf('********************************\n');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 c=ones(m,m).*(1:m);
 r=transpose(c);
 i1=find(sqrt((r-m/2).^2+(c-m/2).^2)<r0);
 f(i1)=0;

 i1=find(sqrt((r-m/2).^2+(c-m/2).^2)>r1);
 f(i1)=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 i1=find((sqrt((r-m/2).^2+(c-m/2).^2)<r0+r0_tol(1))&(f<r0_tol(2)));
 f(i1)=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
 blk=find(f<tol2);
%
 figure(3);
 f2=f;
 f2(blk)=max(max(f));
 imagesc(f2);
 title('Amplitude');
 colormap('gray');
 axis('square');
 colorbar;
%  print -dpng figure1.png
%
%y=[y(m/2+1:m,m/2+1:m) y(m/2+1:m,1:m/2); y(1:m/2,m/2+1:m) y(1:m/2,1:m/2)];
 y=fftshift(y);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 e0=angle(y);
%e0=atan(imag(y)./real(y));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 if(pc)
  e1=[zeros(m,pc) e0(:,abs(pc):m-1) zeros(m,-pc)];
 else
  e1=e0;
 end
 if(pr)
  e2=[zeros(pr,m) ; e1(1:m-abs(pr),:) ; zeros(-pr,m)];
 else
  e2=e1;
 end 
%save phase.dat e2 f blk blk2
 save phase.dat e2 f blk
%
 figure(4);
 e2(blk)=0;
 imagesc(-e2);
 title('Wrapped phase');
 colormap('gray');
 axis('square');
 colorbar;
%print -dpng phase01.png
end
