function ql(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  ql.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   quick look of SRT holography raw-data
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% ql.m  is a function that plots the SRT holo data
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end
 
 [az el c03 c04 c05 c06 c07 c08 c09 c10 c11 c12 c13]=textread(filename,'%f %f %f %f %f %f %f %f %f %f %f %s %s');

 da=diff(az);
 figure(1);
 plot(da,'o');
 ylabel('Azimuth speed (deg/s)');
 xlabel('Points');

 de=diff(el);
 figure(2);
 plot(de,'o');
 ylabel('Elevation speed (deg/s)');
 xlabel('Points');
  
 figure(3);
 plot(az,el,'.b;map points;')
 title('AzEl map') 
end
 
