function map(s0,ca,x1,lutname,fname,mp)
%
%   map(s0,ca,x1,lutname,fname,mp)
%   lutname='axist_parab.txt';
%   fname='map';
%   s0=1;
%   ca=2;
%   x1=[1,2,3];
%
%   mp=512;
%   dx=0.156556;
%   mp=128;
 D=64;
 k0=0.8;
 dx=D/(mp-1)/k0;
 
 map0=load(lutname);
 
 x0=map0(:,x1(1))*1E-3;
 y0=map0(:,x1(2))*1E-3;
 ep0=s0*map0(:,x1(3));

 xx=-dx*(-mp/2:mp/2-1); 
 [x,y] = meshgrid (xx,xx);
%
 ep=griddata (x0,y0,ep0,x,y);
 i0=find(isnan(ep));
 ep(i0)=0.0;
 ep=ep(end:-1:1,:);
%
 i0=find(sqrt(x.^2+y.^2)<4.0);
 ep(i0)=0;
%
 i0=find(abs(ep)>0);
 blk=find(abs(ep)==0);
 printf('RMS=%f\n',(std(ep(i0))));

 imagesc(xx,xx,ep);
 caxis([-ca ca]);
 axis('square');
 colormap('jet');
 colorbar;
 print ([fname,'.png'],'-dpng'); 
 
 u1=ep(end:-1:1,end:-1:1);
 save errmap.dat u1
 save unwr.dat blk
end
