function lut(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  lut.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% lut.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 m=mp;
 dx=D/(mp-1)/k0;
%
%%%%%%%%%%%%%%%%%%%%%%%%%
 fn=[datapath,'act_list.txt'];
 load(fn);
 xpx=act_list(:,5);
 ypx=act_list(:,6);
 xpx=round(xpx/dx*1E-3)+m/2;
 ypx=m+1-(round(ypx/dx*1E-3)+m/2);
%%%%%%%%%%%%%%%%%%%%%%%%%
 fn=[datapath,'att2pnl.txt'];
 load(fn); 
%%%%%%%%%%%%%%%%%%%%%%%%%
 [p1,i1]=panelfit(1:npan,0,m,0,0,datapath);
 save pfit.dat p1 i1
%%%%%%%%%%%%%%%%%%%%%%%%%
 load zern.dat; %u3
%%%%%%%%%%%%%%%%%%%%%%%%%
%
 e=[];
 jack=[];
 for i=1:nact
  c0=xpx(i);
  r0=ypx(i);
  jack=[jack; u3(r0,c0);];
  np=0;
  em=0;
  for j=1:4
   cp=att2pnl(i,j);
   if(cp>0)
    e0(j)=p1(cp,1)*c0+p1(cp,2)*c0^2+p1(cp,3)*r0+p1(cp,4)*r0^2+p1(cp,5)*c0*r0+p1(cp,6);
    em+=e0(j);
    np++;
   else
    e0(j)=0;
   end
  end
  a=em/np;
  e=[e; [e0 a max(abs(a-e0).*(e0!=0))]];
 end
 fid=fopen('lut.txt','w');
 for i=1:nact
%  fprintf(fid,'SRT-%02d-%02d\tT%02dH%02d\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%6.3f\n',act_list(i,2),act_list(i,3),act_list(i,4),act_list(i,2),e(i,1),e(i,2),e(i,3),e(i,4),e(i,5),e(i,6));
  fprintf(fid,'SRT-%02d-%02d\tT%02dH%02d\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%6.3f\t%6.3f\n',act_list(i,2),act_list(i,3),act_list(i,4),act_list(i,2),e(i,1),e(i,2),e(i,3),e(i,4),e(i,5),e(i,6),jack(i));
 end
 fclose(fid);
%
% 
end
