function z=zernike(n,m,x,y,D)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  zernike.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% zernike.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
 R=0.5*D;
 nx=length(x);
 ny=length(y);
 [xm ym]=meshgrid(x,y);
 r=sqrt(xm.^2+ym.^2);
 z0=(r<=R);
 N0=sqrt(2*(n+1)/(1+(m==0)));
%
 z=z0;
 if(n)
   z=zeros(nx,ny);
   theta=atan2(xm,ym);
   for s=0:0.5*(n-abs(m))
     z=z+(-1)^s*fct(n-s)*(r/R).^(n-2*s)/(fct(s)*fct(0.5*(n+abs(m))-s)*fct(0.5*(n-abs(m))-s));
   end
   z=z0.*N0.*z;
   if(m>0)
     z=z.*cos(m*theta);
   elseif(m<0)
     z=z.*sin(-m*theta);
   end
 end
%
end
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function m=fct(n)
  if(n>1)
    m = prod(1:n);
  else
    m = 1;
  end  
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

