function radrms(fconf)
%function [x y u]=radrms(fconf)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 load zern.dat

%   i0=find(abs(u3)>tol4);
%   u3(i0)=sign(u3(i0))*tol4;
 
 x0=((1:mp)-mp/2);
 [xm ym]=meshgrid(x0,x0);
 R=sqrt(xm.^2+ym.^2); 
 d=5;
 x0=y=u=[];
 for r=r0:r1-d
  z=(R>=r);
  z=z.*(R<r+d);
  i0=find(z>0);
%    imagesc(z)
  y=[y ;std(u3(i0))];
  u=[u ;mean(u3(i0))];
  x0=[x0 ; r];
 end  
 dx=D/(mp-1)/k0;
 x=x0*dx;
 y(end-d:end)=y(end-d);
 u(end-d:end)=u(end-d);
 
 figure(1);
 plot(x,y,'*-');
 grid minor on;
 axis([4.5 32]);
 xlabel ('Antenna radius [m]');
 ylabel ('RMS deflession [mm]');

 figure(2);
 plot(x,u,'*-');
 grid minor on;
 axis([4.5 32]); 
 xlabel ('Antenna radius [m]');
 ylabel ('Mean deflession [mm]');
 
 save ('radrms.dat','x', 'y', 'u'); 
end

