function zern(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  zern.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% zern.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 zlabel=['piston(0,0)';
 'tilt(1,-1)';
 'tilt(1,1)';
 'astigmatism(2,-2)';
 'defocus(2,0)';
 'astigmatism(2,2)';
 'trefoil(3,-3)';
 'coma(3,-1)';
 'coma(3,1)';
 'trefoil(3,3)';
 'tetrafoil(4,-4)';
 'astigmatism(4,-2)';
 'spherical(4,0)';
 'astigmatism(4,2)';
 'tetrafoil(4,4)';
 'pentafoil(5,-5)';
 'trefoil(5,-3)';
 'coma(5,-1)';
 'coma(5,1)';
 'trefoil(5,3)';
 'pentafoil(5,5)';
 'hexafoil(6,-6)';
 'tetrafoil(6,-4)';
 'astigmatism(6,-2)';
 'spherical(6,0)';
 'astigmatism(6,2)';
 'tetrafoil(6,4)';
 'hexafoil(6,6)';
 '(7,-7)';
 '(7,-5)';
 '(7,-3)';
 '(7,-1)';
 '(7,1)';
 '(7,3)';
 '(7,5)';
 '(7,7)';];

  n1=[0  1 1  2 2 2  3  3 3 3  4  4 4 4 4  5  5  5 5 5 5  6  6  6 6 6 6 6   7  7  7  7 7 7 7 7 ];
  m1=[0 -1 1 -2 0 2 -3 -1 1 3 -4 -2 0 2 4 -5 -3 -1 1 3 5 -6 -4 -2 0 2 4 6  -7 -5 -3 -1 1 3 5 7 ];
  
%    jet0=jet;
%    jet0=[jet0(1:32,:);[1 1 1];jet0(33:64,:)];
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 load errmap.dat
 if(zp(1)==0)
  c=0;
  u3=u1;
  uz=zeros(mp,mp);
  save zern.dat u3 uz c
  return;
 end
 if(max(zp)>length(n1))
  err_msg=sprintf("zp can\'t be greater than %d.\n",length(n1));
  error(err_msg);
 end
 load unwr.dat
 
 zlabel=zlabel(zp,:);
 n1=n1(zp);
 m1=m1(zp); 
 nz=length(n1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 u2=reshape(u1,mp*mp,1);
 u2(blk)=[];
 stdg=std(u2);
 x0=((1:mp)-mp/2);
 A=[];
 for i=1:nz
  Z=zernike(n1(i),m1(i),x0,x0,r1*2);
  z=reshape(Z,mp*mp,1);
  z(blk)=[];
  A=[A z]; 
 end
 c=A\u2;
%   c(4)=.2;
 uz=zeros(mp,mp);
 for i=1:nz
  Z=zernike(n1(i),m1(i),x0,x0,r1*2);
  uz=uz+Z*c(i); 
 end
 u3=u1-uz; 
 u3(blk)=0;
 u4=u3;
%   j0=(find(abs(u3)>tol4));
%   u4(j0)=0;
 
 figure(1); 
 dx=D/(mp-1)/k0;
 switch(panels)
  case(1)
   fname=[datapath,'jacks.dat'];
   load(fname);
   R=D/2;
   jx=round((jx)*r1/R)+mp/2;
   jy=round((jy)*r1/R)+mp/2;
   jy=mp+1-jy;
   for k=1:length(jx)
    u4(jx(k),jy(k))=tol4;
   end  
 case(2) 
   fname=[datapath,'panel.dat'];
   load(fname);
   p1=map0.*(map0==1);
   ip1=find(p1==0);
   u4(ip1)=tol4;
   u4(blk)=0;
 end
 
 imagesc(dx*(-mp/2:mp/2),dx*(-mp/2:mp/2),u4);
 caxis([-tol4 tol4]);
 axis('square');
 title('corrected map (mm)');
%colormap('bone');
 colormap(cmap);
 colorbar;
%print -dpng corrected.png

 figure(2); 
 imagesc(dx*(-mp/2:mp/2),dx*(-mp/2:mp/2),uz);
 axis('square');
 title('zernike pol. map (mm)');
 colormap('gray');
%colormap('jet');
 colorbar;
%print -dpng zern.png
  
 figure(3);
 cn=c/sum(abs(c))*100;
 plot(1:nz,cn,'*-','LineWidth',4)
 grid minor on;
 title('zernike pol. [%]');
 h0=text((1:nz),cn+max(abs(cn))*0.04,zlabel(1:nz,:));
 set(h0,'rotation',90); %,'horizontalalignment','right');
% print -dpng coeffz.png

 save zern.dat u3 uz c
% save zern.dat u3 u4 uz c
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
printf('********************************\n');
%  im=find((abs(u3)>0)&(abs(u3)<=tol4));
%  std3=std(u3(im));
%  printf('small scale RMS(tol4) = %f [mm]\n',std3);

im=find(abs(u3)>0);
std3=std(u3(im));
printf('small scale RMS = %f [mm]\n',std3);

im=find(abs(uz)>0);
stdz=std(uz(im));
printf('large scale RMS = %f [mm]\n',stdz);

%  printf('RMS(global)=%f [mm]\n',sqrt(std3^2+stdz^2));
printf('global RMS = %f [mm]\n',stdg);
printf('********************************\n');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
end
 