function unwr1(fconf)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  unwr1.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   quick look of SRT holography raw-data
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% unwr1.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 if nargin>0
  run(fconf); 
 else
  run('conf.m');
 end
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 

 load phase.dat
 w0=e2;
% 
% l1=[-1 -1 ;-1 0;-1 +1;0 -1;0 +1;1 -1;1 0;1 1];
 l1=[0 -1;0 1;-1 0;1 0];
 l0=length(l1);
 u0=zeros(mp,mp);
 m0=ones(mp,mp);
 m0(blk)=0;
 m0(i1,j1)=0;
 u0(i1,j1)=w0(i1,j1);
 stki=i1;
 stkj=j1;
 for k1=1:n2
  if(length(stki)==0)
   break;
  end
  i1=stki(end);
  j1=stkj(end);
    
  stki(end)=[];
  stkj(end)=[];
%
  l1=[l1(end,:);l1(1:end-1,:)];
%
  for i0=1:l0
   i2=i1+l1(i0,1);
   j2=j1+l1(i0,2);
%     
   if m0(i2,j2)
      u=[];
      f0=[];
      for j3=1:l0
       if(m0(i2+l1(j3,1),j2+l1(j3,2))==0)
        u=[u; u0(i2+l1(j3,1),j2+l1(j3,2)) ];
        f0=[f0; f(i2+l1(j3,1),j2+l1(j3,2)) ];
       end
      end 
      [fmx,jf]=max(f0);
      u=u(jf);
      m0(i2,j2)=0;
      w=w0(i2,j2);
      u0(i2,j2)=(abs((u-w)/pi)>tol)*(round((u-w)/pi)*pi)+w;
      stki(end+1)=i2;
      stkj(end+1)=j2;      
   end   
  end
 end
 printf('%d/%d iterations\n',k1,n2);
 figure(1);
 imagesc(u0);
 axis('square');
 colormap('gray');
 colorbar;
 title('unwrapped map');
 save unwr.dat u0 blk
end
 