function [p1 i1]=panelfit(k0,p0,m,a0,b0,datapath)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Function:  panelfit.m
% Package:   HoP
% Author:    Franco Buffa
% Purpose:   
% Date:      
%	
% GNU Octave Version: 4.0.2
%
% revised by 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% panelfit.m  is a function that 
%
% Output:
% 
%
% Input:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  panelfit(408,3,512,130,20,'datapath') 
%
%  panel.dat:    map0 (panel map)
%  panelpix.dat: ppx (px index for each panel) npx (n. of px for each panel)
%  map.png (map0 image)
%
%  The index of the j-th px of the i-th panel is: sum(npx(1:i-1))+1<=j<=npx(i)-1
%

 fn=[datapath,'panelpix.dat'];
 load(fn); 
 load zern.dat; %u3
 u0=u3;
% 
 [c,r] = meshgrid (1:m,1:m);
%
 p1=i1=[];
 for k=k0
  j0=ppx(npx(k,1):npx(k,2))';
  s0=u0(j0)';
  r0=r(j0)';
  c0=c(j0)';
  n0=length(j0);
%
%  A=[ c0 c0.^2 c0.^3 r0 r0.^2 r0.^3 c0.*r0 ones(n0,1)];
  A=[ c0 c0.^2 r0 r0.^2 c0.*r0 ones(n0,1)];
% A=[ c0 r0 c0.*r0 ones(n0,1)];
  p=A\s0;
  s1=A*p;
  p1=[p1;p'];
  i1=[i1; [k,n0,mean(s0),std(s0),std(A*p-s0)]];
  if length(k0)==1
   figure(1);
   %plot(s1,s0,'*')
   plot3(c0,r0,s0,'*',c0,r0,s1,'or');
   view (a0,b0);
   print -dpng -r300 'panel.png' 
 
   figure(2);
   u0(j0)=-Inf;
   imagesc(u0);
   caxis([-p0 p0]);
   axis('square');
   colormap ('jet')
   colorbar;
 end 
 
end
